/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.symfony2.Bundle;
import org.netbeans.modules.php.symfony2.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony2.SymfonyVersion;
import org.netbeans.modules.php.symfony2.preferences.SymfonyPreferences;
import org.netbeans.modules.php.symfony2.ui.customizer.SymfonyCustomizerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class SymfonyPhpModuleCustomizerExtender
extends PhpModuleCustomizerExtender {
    private final PhpModule phpModule;
    private final boolean originalEnabled;
    private final String originalAppDir;
    private final boolean originalCacheDirIgnored;
    private SymfonyCustomizerPanel component;
    private boolean valid = false;
    private String errorMessage = null;

    SymfonyPhpModuleCustomizerExtender(PhpModule phpModule) {
        this.phpModule = phpModule;
        this.originalEnabled = SymfonyPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
        this.originalAppDir = SymfonyPreferences.getAppDir(phpModule);
        this.originalCacheDirIgnored = SymfonyPreferences.isCacheDirIgnored(phpModule);
    }

    public String getDisplayName() {
        return Bundle.LBL_Symfony2();
    }

    public String getDisplayName(PhpModule phpModule) {
        SymfonyVersion symfonyVersion = SymfonyVersion.forPhpModule(phpModule);
        if (symfonyVersion != null) {
            return symfonyVersion.getFrameworkName(true);
        }
        return this.getDisplayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        this.validate();
        return this.valid;
    }

    public String getErrorMessage() {
        this.validate();
        return this.errorMessage;
    }

    public EnumSet<PhpModuleCustomizerExtender.Change> save(PhpModule phpModule) {
        EnumSet<PhpModuleCustomizerExtender.Change> changes = EnumSet.noneOf(PhpModuleCustomizerExtender.Change.class);
        this.saveEnabled(changes);
        this.saveAppDir(changes);
        this.saveCacheIgnored(changes);
        if (changes.isEmpty()) {
            return null;
        }
        return changes;
    }

    private void saveEnabled(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        boolean newEnabled = this.getPanel().isSupportEnabled();
        if (newEnabled != this.originalEnabled) {
            SymfonyPreferences.setEnabled(this.phpModule, newEnabled);
            changes.add(PhpModuleCustomizerExtender.Change.FRAMEWORK_CHANGE);
        }
    }

    private void saveAppDir(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        String newAppDir = this.getPanel().getAppDirectory();
        if (!newAppDir.equals(this.originalAppDir)) {
            SymfonyPreferences.setAppDir(this.phpModule, newAppDir);
            changes.add(PhpModuleCustomizerExtender.Change.FRAMEWORK_CHANGE);
        }
    }

    private void saveCacheIgnored(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        boolean newIgnored = this.getPanel().isIgnoreCacheDirectory();
        if (newIgnored != this.originalCacheDirIgnored) {
            SymfonyPreferences.setCacheDirIgnored(this.phpModule, newIgnored);
            changes.add(PhpModuleCustomizerExtender.Change.IGNORED_FILES_CHANGE);
        }
    }

    private SymfonyCustomizerPanel getPanel() {
        if (this.component == null) {
            this.component = new SymfonyCustomizerPanel(this.phpModule.getSourceDirectory());
            this.component.setSupportEnabled(this.originalEnabled);
            this.component.setAppDirectory(this.originalAppDir);
            this.component.setIgnoreCacheDirectory(this.originalCacheDirIgnored);
        }
        return this.component;
    }

    private void validate() {
        SymfonyCustomizerPanel panel = this.getPanel();
        if (!panel.isSupportEnabled()) {
            this.valid = true;
            this.errorMessage = null;
            return;
        }
        String appDir = panel.getAppDirectory();
        if (!StringUtils.hasText((String)appDir)) {
            this.valid = false;
            this.errorMessage = Bundle.SymfonyPhpModuleCustomizerExtender_error_appDir_empty();
            return;
        }
        FileObject sources = this.phpModule.getSourceDirectory();
        if (sources == null) {
            assert (false) : "Customizer extender for no sources of: " + this.phpModule.getName();
            this.valid = false;
            this.errorMessage = Bundle.SymfonyPhpModuleCustomizerExtender_error_sources_invalid();
            return;
        }
        FileObject fo = sources.getFileObject(appDir);
        if (fo == null || !FileUtil.isParentOf((FileObject)sources, (FileObject)fo)) {
            this.valid = false;
            this.errorMessage = Bundle.SymfonyPhpModuleCustomizerExtender_error_appDir_notChild();
            return;
        }
        this.valid = true;
        this.errorMessage = null;
    }
}

