/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class LocalServerController {
    private final JComboBox<LocalServer> localServerComboBox;
    private final JButton localServerBrowseButton;
    private final SourcesFolderProvider sourcesFolderProvider;
    private final String browseDialogTitle;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private MutableComboBoxModel<LocalServer> localServerComboBoxModel;
    private final LocalServer.ComboBoxEditor localServerComboBoxEditor;
    private final BrowseHandler browseHandler;

    public static LocalServerController create(JComboBox<LocalServer> localServerComboBox, JButton localServerBrowseButton, SourcesFolderProvider sourcesFolderProvider, BrowseHandler browseHandler, String browseDialogTitle, LocalServer ... defaultLocalServers) {
        return new LocalServerController(localServerComboBox, localServerBrowseButton, sourcesFolderProvider, browseHandler, browseDialogTitle, defaultLocalServers);
    }

    public static LocalServerController create(JComboBox<LocalServer> localServerComboBox, JButton localServerBrowseButton, BrowseHandler browseHandler, String browseDialogTitle, LocalServer ... defaultLocalServers) {
        return new LocalServerController(localServerComboBox, localServerBrowseButton, null, browseHandler, browseDialogTitle, defaultLocalServers);
    }

    private LocalServerController(JComboBox<LocalServer> localServerComboBox, JButton localServerBrowseButton, SourcesFolderProvider sourcesFolderProvider, BrowseHandler browseHandler, String browseDialogTitle, LocalServer ... defaultLocalServers) {
        assert (localServerComboBox != null);
        assert (localServerBrowseButton != null);
        assert (browseHandler != null);
        assert (browseDialogTitle != null);
        assert (localServerComboBox.isEditable()) : "localServerComboBox has to be editable";
        assert (localServerComboBox.getEditor().getEditorComponent() instanceof JTextField);
        this.localServerComboBox = localServerComboBox;
        this.localServerBrowseButton = localServerBrowseButton;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.browseHandler = browseHandler;
        this.browseDialogTitle = browseDialogTitle;
        this.localServerComboBoxModel = new LocalServer.ComboBoxModel(defaultLocalServers);
        JTextField editor = (JTextField)localServerComboBox.getEditor().getEditorComponent();
        this.localServerComboBoxEditor = new LocalServer.ComboBoxEditor(editor);
        localServerComboBox.setModel(this.localServerComboBoxModel);
        localServerComboBox.setRenderer(new LocalServer.ComboBoxRenderer());
        localServerComboBox.setEditor(this.localServerComboBoxEditor);
        this.registerListeners();
    }

    private void registerListeners() {
        this.localServerComboBoxEditor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocalServerController.this.changeSupport.fireChange();
            }
        });
        this.localServerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newSubfolderName = null;
                if (LocalServerController.this.sourcesFolderProvider != null) {
                    newSubfolderName = LocalServerController.this.sourcesFolderProvider.getSourcesFolderName();
                }
                Utils.browseLocalServerAction(LocalServerController.this.localServerComboBox, LocalServerController.this.localServerComboBoxModel, newSubfolderName, LocalServerController.this.browseDialogTitle, LocalServerController.this.browseHandler.getDirKey());
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public LocalServer getLocalServer() {
        return (LocalServer)this.localServerComboBox.getSelectedItem();
    }

    public MutableComboBoxModel<LocalServer> getLocalServerModel() {
        return this.localServerComboBoxModel;
    }

    public void setLocalServerModel(MutableComboBoxModel<LocalServer> localServers) {
        this.localServerComboBoxModel = localServers;
        this.localServerComboBox.setModel(this.localServerComboBoxModel);
    }

    public void addLocalServer(LocalServer localServer) {
        this.localServerComboBox.addItem(localServer);
    }

    public void selectLocalServer(LocalServer localServer) {
        this.localServerComboBox.setSelectedItem(localServer);
    }

    public void setEnabled(boolean enabled) {
        this.localServerComboBox.setEnabled(enabled);
        this.localServerComboBox.setEditable(enabled);
        this.localServerBrowseButton.setEnabled(enabled);
    }

    public static String validateLocalServer(LocalServer localServer, String type, boolean allowNonEmpty, boolean allowInRoot) {
        if (!localServer.isEditable()) {
            return null;
        }
        String err = null;
        String sourcesLocation = localServer.getSrcRoot();
        File sources = FileUtil.normalizeFile((File)new File(sourcesLocation));
        err = sourcesLocation.trim().length() == 0 || !Utils.isValidFileName(sources) ? NbBundle.getMessage(LocalServerController.class, (String)("MSG_Illegal" + type + "Name")) : Utils.validateProjectDirectory(sourcesLocation, type, allowNonEmpty, allowInRoot);
        return err;
    }

    public static interface BrowseHandler {
        public String getDirKey();
    }
}

