/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

public final class TransferInfo {
    private final Set<TransferFile> transfered = new HashSet<TransferFile>();
    private final Map<TransferFile, String> failed = new HashMap<TransferFile, String>();
    private final Map<TransferFile, String> partiallyFailed = new HashMap<TransferFile, String>();
    private final Map<TransferFile, String> ignored = new HashMap<TransferFile, String>();
    private long runtime;

    public Set<TransferFile> getTransfered() {
        return this.transfered;
    }

    public Map<TransferFile, String> getFailed() {
        return this.failed;
    }

    public Map<TransferFile, String> getPartiallyFailed() {
        return this.partiallyFailed;
    }

    public Map<TransferFile, String> getIgnored() {
        return this.ignored;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public boolean isTransfered(TransferFile transferFile) {
        return this.transfered.contains(transferFile);
    }

    public boolean isFailed(TransferFile transferFile) {
        return this.failed.containsKey(transferFile);
    }

    public boolean isPartiallyFailed(TransferFile transferFile) {
        return this.partiallyFailed.containsKey(transferFile);
    }

    public boolean isIgnored(TransferFile transferFile) {
        return this.ignored.containsKey(transferFile);
    }

    public boolean hasAnyTransfered() {
        return !this.transfered.isEmpty();
    }

    public boolean hasAnyFailed() {
        return !this.failed.isEmpty();
    }

    public boolean hasAnyPartiallyFailed() {
        return !this.partiallyFailed.isEmpty();
    }

    public boolean hasAnyIgnored() {
        return !this.ignored.isEmpty();
    }

    public void addTransfered(TransferFile transferFile) {
        this.assertNotContains(this.failed.keySet(), transferFile, "failed", "transfered");
        this.assertNotContains(this.ignored.keySet(), transferFile, "ignored", "transfered");
        this.transfered.add(transferFile);
    }

    public void addFailed(TransferFile transferFile, String reason) {
        this.assertNotContains(this.transfered, transferFile, "transfered", "failed");
        this.assertNotContains(this.ignored.keySet(), transferFile, "ignored", "failed");
        this.assertNotContains(this.partiallyFailed.keySet(), transferFile, "partially failed", "failed");
        this.failed.put(transferFile, reason);
    }

    public void addPartiallyFailed(TransferFile transferFile, String reason) {
        this.assertNotContains(this.failed.keySet(), transferFile, "failed", "partially failed");
        this.assertNotContains(this.ignored.keySet(), transferFile, "ignored", "partially failed");
        this.partiallyFailed.put(transferFile, reason);
    }

    public void addIgnored(TransferFile transferFile, String reason) {
        this.assertNotContains(this.transfered, transferFile, "transfered", "ignored");
        this.assertNotContains(this.failed.keySet(), transferFile, "failed", "ignored");
        this.assertNotContains(this.partiallyFailed.keySet(), transferFile, "partially failed", "ignored");
        this.ignored.put(transferFile, reason);
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [transfered: ");
        sb.append(this.transfered);
        sb.append(", failed: ");
        sb.append(this.failed);
        sb.append(", partially failed: ");
        sb.append(this.partiallyFailed);
        sb.append(", ignored: ");
        sb.append(this.ignored);
        sb.append(", runtime: ");
        sb.append(this.runtime);
        sb.append(" ms]");
        return sb.toString();
    }

    private void assertNotContains(Collection<TransferFile> collection, TransferFile transferFile, String collectionType, String fileType) {
        assert (!collection.contains(transferFile)) : collectionType + " files should not contain " + fileType + " file";
    }
}

