/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.LocalTransferFile;
import org.netbeans.modules.php.project.connections.transfer.RemoteTransferFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class TransferFile {
    private static final Logger LOGGER = Logger.getLogger(TransferFile.class.getName());
    public static final String REMOTE_PATH_SEPARATOR = "/";
    public static final String REMOTE_PROJECT_ROOT = ".";
    public static final Comparator<TransferFile> TRANSFER_FILE_COMPARATOR = new Comparator<TransferFile>(){

        @Override
        public int compare(TransferFile file1, TransferFile file2) {
            return file1.getRemotePath().compareToIgnoreCase(file2.getRemotePath());
        }
    };
    protected final RemoteClientImplementation remoteClient;
    protected final TransferFile parent;
    private final ReadWriteLock localChildrenLock = new ReentrantReadWriteLock();
    private final ReadWriteLock remoteChildrenLock = new ReentrantReadWriteLock();
    private Set<TransferFile> localChildren = null;
    private Set<TransferFile> remoteChildren = null;
    private volatile Long timestamp = null;
    private Long size = null;

    TransferFile(RemoteClientImplementation remoteClient, TransferFile parent) {
        assert (remoteClient != null);
        this.remoteClient = remoteClient;
        this.parent = parent;
        String baseRemoteDirectory = remoteClient.getBaseRemoteDirectory();
        if (!baseRemoteDirectory.startsWith(REMOTE_PATH_SEPARATOR)) {
            throw new IllegalArgumentException("Base directory '" + baseRemoteDirectory + "' must start with '/'");
        }
    }

    public static TransferFile fromFileObject(RemoteClientImplementation remoteClient, TransferFile parent, FileObject fo) {
        assert (fo != null);
        return TransferFile.fromFile(remoteClient, parent, FileUtil.toFile((FileObject)fo), fo.isFolder());
    }

    public static TransferFile fromFile(RemoteClientImplementation remoteClient, TransferFile parent, File file) {
        return TransferFile.fromFile(remoteClient, parent, file, false);
    }

    public static TransferFile fromDirectory(RemoteClientImplementation remoteClient, TransferFile parent, File file) {
        return TransferFile.fromFile(remoteClient, parent, file, true);
    }

    public static TransferFile fromRemoteFile(RemoteClientImplementation remoteClient, TransferFile parent, RemoteFile remoteFile) {
        RemoteTransferFile transferFile = new RemoteTransferFile(remoteClient, remoteFile, parent);
        if (parent != null) {
            parent.addRemoteChild(transferFile);
        }
        return transferFile;
    }

    private static TransferFile fromFile(RemoteClientImplementation remoteClient, TransferFile parent, File file, boolean forceDirectory) {
        LocalTransferFile transferFile = new LocalTransferFile(remoteClient, FileUtil.normalizeFile((File)file), parent, forceDirectory);
        if (parent != null) {
            parent.addLocalChild(transferFile);
        }
        return transferFile;
    }

    public final List<TransferFile> getLocalChildren() {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        this.initLocalChildren();
        this.localChildrenLock.readLock().lock();
        try {
            ArrayList<TransferFile> arrayList = new ArrayList<TransferFile>(this.localChildren);
            return arrayList;
        }
        finally {
            this.localChildrenLock.readLock().unlock();
        }
    }

    public boolean hasLocalChildrenFetched() {
        if (!this.isDirectory()) {
            return true;
        }
        this.localChildrenLock.readLock().lock();
        try {
            boolean bl = this.localChildren != null;
            return bl;
        }
        finally {
            this.localChildrenLock.readLock().unlock();
        }
    }

    public final List<TransferFile> getRemoteChildren() {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        this.initRemoteChildren();
        this.remoteChildrenLock.readLock().lock();
        try {
            ArrayList<TransferFile> arrayList = new ArrayList<TransferFile>(this.remoteChildren);
            return arrayList;
        }
        finally {
            this.remoteChildrenLock.readLock().unlock();
        }
    }

    public boolean hasRemoteChildrenFetched() {
        if (!this.isDirectory()) {
            return true;
        }
        this.remoteChildrenLock.readLock().lock();
        try {
            boolean bl = this.remoteChildren != null;
            return bl;
        }
        finally {
            this.remoteChildrenLock.readLock().unlock();
        }
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final TransferFile getParent() {
        if (this.isProjectRoot()) {
            throw new IllegalStateException("Cannot get parent on project root.");
        }
        return this.parent;
    }

    public final String getBaseLocalDirectoryPath() {
        return this.remoteClient.getBaseLocalDirectory();
    }

    public final String getBaseRemoteDirectoryPath() {
        return this.remoteClient.getBaseRemoteDirectory();
    }

    public final String getLocalAbsolutePath() {
        return this.resolveLocalFile().getAbsolutePath();
    }

    public final String getRemoteAbsolutePath() {
        String remotePath = this.getRemotePath();
        if (remotePath == REMOTE_PROJECT_ROOT) {
            return this.getBaseRemoteDirectoryPath();
        }
        Object baseRemotePath = this.getBaseRemoteDirectoryPath();
        if (!((String)baseRemotePath).endsWith(REMOTE_PATH_SEPARATOR)) {
            baseRemotePath = (String)baseRemotePath + REMOTE_PATH_SEPARATOR;
        }
        return (String)baseRemotePath + remotePath;
    }

    public boolean isRoot() {
        if (this.isProjectRoot()) {
            return true;
        }
        return !this.hasParent();
    }

    public boolean isProjectRoot() {
        return REMOTE_PROJECT_ROOT == this.getRemotePath();
    }

    public abstract String getName();

    public abstract String getRemotePath();

    public final String getParentRemotePath() {
        if (this.getParent() != null) {
            return this.getParent().getRemotePath();
        }
        ArrayList fragments = new ArrayList(StringUtils.explode((String)this.getRemotePath(), (String)REMOTE_PATH_SEPARATOR));
        fragments.remove(fragments.size() - 1);
        if (fragments.isEmpty()) {
            return REMOTE_PROJECT_ROOT;
        }
        return StringUtils.implode(fragments, (String)REMOTE_PATH_SEPARATOR);
    }

    public final String getLocalPath() {
        String remotePath = this.getRemotePath();
        if (File.separator.equals(REMOTE_PATH_SEPARATOR)) {
            return remotePath;
        }
        return remotePath.replace(REMOTE_PATH_SEPARATOR, File.separator);
    }

    public File resolveLocalFile() {
        return this.resolveLocalFile(new File(this.getBaseLocalDirectoryPath()));
    }

    public File resolveLocalFile(File directory) {
        if (directory == null) {
            throw new NullPointerException();
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory must be provided (both existing and non-existing allowed)");
        }
        if (this.isProjectRoot()) {
            return directory;
        }
        return new File(directory, this.getLocalPath());
    }

    public final long getSize() {
        if (this.size == null) {
            this.size = this.getSizeImpl();
            if (this.size < 0L) {
                throw new IllegalArgumentException("Size cannot be smaller than 0");
            }
            if (this.isDirectory() && this.size != 0L) {
                throw new IllegalArgumentException("Size of a directory has to be 0 bytes");
            }
        }
        return this.size;
    }

    protected abstract long getSizeImpl();

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isLink();

    public final long getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = this.getTimestampImpl();
        }
        return this.timestamp;
    }

    protected abstract long getTimestampImpl();

    public final void touch() {
        this.timestamp = new Date().getTime();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferFile)) {
            return false;
        }
        TransferFile other = (TransferFile)obj;
        return this.getRemotePath().equals(other.getRemotePath());
    }

    public int hashCode() {
        return this.getRemotePath().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name: " + this.getName() + ", remotePath: " + this.getRemotePath() + ", baseLocalDirectoryPath: " + this.getBaseLocalDirectoryPath() + ", baseRemoteDirectoryPath: " + this.getBaseRemoteDirectoryPath() + ", hasParent: " + this.hasParent() + ", isFile: " + this.isFile() + ", isDirectory: " + this.isDirectory() + ", isLink: " + this.isLink() + "]";
    }

    private void addLocalChild(TransferFile child) {
        if (!this.isDirectory()) {
            throw new IllegalStateException("Cannot add child to not directory: " + this);
        }
        this.initLocalChildren();
        this.localChildrenLock.writeLock().lock();
        try {
            this.localChildren.add(child);
        }
        finally {
            this.localChildrenLock.writeLock().unlock();
        }
    }

    private void addRemoteChild(TransferFile child) {
        if (!this.isDirectory()) {
            throw new IllegalStateException("Cannot add child to not directory: " + this);
        }
        this.initRemoteChildren();
        this.remoteChildrenLock.writeLock().lock();
        try {
            this.remoteChildren.add(child);
        }
        finally {
            this.remoteChildrenLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLocalChildren() {
        boolean fetchChildren;
        block11: {
            fetchChildren = false;
            this.localChildrenLock.readLock().lock();
            try {
                if (this.localChildren != null) break block11;
                this.localChildrenLock.readLock().unlock();
                this.localChildrenLock.writeLock().lock();
                try {
                    if (this.localChildren == null) {
                        this.localChildren = new LinkedHashSet<TransferFile>();
                        fetchChildren = true;
                    }
                }
                finally {
                    this.localChildrenLock.readLock().lock();
                    this.localChildrenLock.writeLock().unlock();
                }
            }
            finally {
                this.localChildrenLock.readLock().unlock();
            }
        }
        if (fetchChildren) {
            Collection<TransferFile> fetchedChildren = this.fetchLocalChildren();
            this.localChildrenLock.writeLock().lock();
            try {
                this.localChildren.addAll(fetchedChildren);
            }
            finally {
                this.localChildrenLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRemoteChildren() {
        boolean fetchChildren;
        block11: {
            fetchChildren = false;
            this.remoteChildrenLock.readLock().lock();
            try {
                if (this.remoteChildren != null) break block11;
                this.remoteChildrenLock.readLock().unlock();
                this.remoteChildrenLock.writeLock().lock();
                try {
                    if (this.remoteChildren == null) {
                        this.remoteChildren = new LinkedHashSet<TransferFile>();
                        fetchChildren = true;
                    }
                }
                finally {
                    this.remoteChildrenLock.readLock().lock();
                    this.remoteChildrenLock.writeLock().unlock();
                }
            }
            finally {
                this.remoteChildrenLock.readLock().unlock();
            }
        }
        if (fetchChildren) {
            Collection<TransferFile> fetchedChildren = this.fetchRemoteChildren();
            this.remoteChildrenLock.writeLock().lock();
            try {
                this.remoteChildren.addAll(fetchedChildren);
            }
            finally {
                this.remoteChildrenLock.writeLock().unlock();
            }
        }
    }

    private Collection<TransferFile> fetchLocalChildren() {
        LOGGER.log(Level.FINE, "Fetching local children for {0}", this);
        return this.remoteClient.listLocalFiles(this);
    }

    private Collection<TransferFile> fetchRemoteChildren() {
        LOGGER.log(Level.FINE, "Fetching remote children for {0}", this);
        try {
            return this.remoteClient.listRemoteFiles(this);
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.INFO, "Error while getting children for " + this, ex);
            RemoteUtils.processRemoteException(ex);
            return Collections.emptyList();
        }
    }
}

