/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.testrunner.Bundle;
import org.netbeans.modules.php.project.ui.testrunner.ControllableRerunHandler;
import org.netbeans.modules.php.project.ui.testrunner.JumpToCallStackAction;
import org.netbeans.modules.php.project.ui.testrunner.PhpTestRunnerNodeFactory;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionImpl;
import org.netbeans.modules.php.project.ui.testrunner.TestSessions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.project.util.UsageLogging;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class UnitTestRunner {
    private static final Logger LOGGER = Logger.getLogger(UnitTestRunner.class.getName());
    private static final Manager MANAGER = Manager.getInstance();
    private final PhpProject project;
    private final TestSession testSession;
    private final TestRunInfo info;
    private final ControllableRerunHandler rerunHandler;
    private final PhpCoverageProvider coverageProvider;
    private final List<PhpTestingProvider> testingProviders;

    public UnitTestRunner(PhpProject project, TestRunInfo info, ControllableRerunHandler rerunHandler) {
        this(project, info, rerunHandler, project.getTestingProviders());
    }

    public UnitTestRunner(PhpProject project, TestRunInfo info, ControllableRerunHandler rerunHandler, List<PhpTestingProvider> testingProviders) {
        assert (project != null);
        assert (rerunHandler != null);
        assert (info != null);
        assert (testingProviders != null);
        this.project = project;
        this.info = info;
        this.rerunHandler = rerunHandler;
        this.coverageProvider = (PhpCoverageProvider)project.getLookup().lookup(PhpCoverageProvider.class);
        assert (this.coverageProvider != null);
        this.testingProviders = testingProviders;
        MANAGER.setNodeFactory((TestRunnerNodeFactory)new PhpTestRunnerNodeFactory(new CallStackCallback(project)));
        this.testSession = new TestSession(this.getOutputTitle(project, info), (Project)project, this.map(info.getSessionType()));
        this.testSession.setRerunHandler((RerunHandler)rerunHandler);
    }

    public void run() {
        if (!this.checkTestingProviders()) {
            return;
        }
        UsageLogging.logPhpTestRun(this.project, this.testingProviders);
        try {
            this.rerunHandler.disable();
            MANAGER.testStarted(this.testSession);
            TestSessions sessions = this.runInternal();
            this.handleCodeCoverage(sessions);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            MANAGER.sessionFinished(this.testSession);
            this.rerunHandler.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestSessions runInternal() {
        TestSessions testSessions = new TestSessions();
        boolean error = false;
        for (PhpTestingProvider testingProvider : this.testingProviders) {
            TestSessionImpl testSessionImpl = new TestSessionImpl(MANAGER, this.testSession, testingProvider);
            testSessions.addTestSession(testSessionImpl);
            try {
                LOGGER.log(Level.FINE, "Running {0} tests...", testingProvider.getIdentifier());
                testingProvider.runTests(this.project.getPhpModule(), this.info, (org.netbeans.modules.php.spi.testing.run.TestSession)testSessionImpl);
                LOGGER.fine("Test run finished");
            }
            catch (TestRunException exc) {
                LOGGER.log(Level.INFO, null, exc);
                error = true;
                testSessionImpl.setTestException(true);
            }
            finally {
                testSessionImpl.freeze();
            }
        }
        if (error) {
            MANAGER.displayOutput(this.testSession, Bundle.UnitTestRunner_error_running(), true);
        }
        return testSessions;
    }

    private boolean checkTestingProviders() {
        if (!this.testingProviders.isEmpty()) {
            return true;
        }
        PhpProjectUtils.openCustomizer(this.project, "Testing");
        return false;
    }

    private void handleCodeCoverage(TestSessions sessions) {
        if (!this.coverageProvider.isEnabled()) {
            return;
        }
        if (!this.info.isCoverageEnabled()) {
            return;
        }
        PhpModule phpModule = this.project.getPhpModule();
        for (TestSessionImpl session : sessions.getTestSessions()) {
            PhpTestingProvider testingProvider = session.getTestingProvider();
            if (!testingProvider.isCoverageSupported(phpModule)) {
                MANAGER.displayOutput(this.testSession, Bundle.UnitTestRunner_error_coverage(testingProvider.getDisplayName()), true);
                continue;
            }
            if (session.isTestException()) {
                LOGGER.log(Level.FINE, "No coverage available due to test exception for {0}", testingProvider.getIdentifier());
                continue;
            }
            if (!session.isCoverageSet()) {
                throw new IllegalStateException("Code coverage was not set for " + testingProvider.getIdentifier() + " (forgot to call TestSession.setCoverage(Coverage)?)");
            }
            Coverage coverage = session.getCoverage();
            if (coverage == null) {
                LOGGER.log(Level.INFO, "Code coverage set to null for provider {0}", testingProvider.getIdentifier());
                continue;
            }
            if (coverage.getFiles().isEmpty()) {
                LOGGER.log(Level.INFO, "Ignoring code coverage for provider {0}, it contains no data", testingProvider.getIdentifier());
                continue;
            }
            if (this.info.allTests()) {
                this.coverageProvider.setCoverage(coverage);
                continue;
            }
            this.coverageProvider.updateCoverage(coverage);
        }
    }

    private String getOutputTitle(PhpProject project, TestRunInfo info) {
        String suiteName;
        StringBuilder sb = new StringBuilder(30);
        sb.append(project.getName());
        String testRootName = this.getTestRootName(project, info);
        if (testRootName != null) {
            sb.append("[");
            sb.append(testRootName);
            sb.append("]");
        }
        if ((suiteName = info.getSuiteName()) != null) {
            sb.append(":");
            sb.append(suiteName);
        }
        return sb.toString();
    }

    @CheckForNull
    private String getTestRootName(PhpProject project, TestRunInfo info) {
        FileObject[] testRoots = project.getTestRoots().getRoots();
        if (testRoots.length == 1) {
            return null;
        }
        int idx = -1;
        block0: for (FileObject file : info.getStartFiles()) {
            for (int i = 0; i < testRoots.length; ++i) {
                FileObject testRoot = testRoots[i];
                if (!FileUtil.isParentOf((FileObject)testRoot, (FileObject)file)) continue;
                if (idx == -1) {
                    idx = i;
                    continue block0;
                }
                if (idx == i) continue;
                idx = -1;
                break block0;
            }
        }
        if (idx == -1) {
            return null;
        }
        return project.getTestRoots().getPureRootNames()[idx];
    }

    private TestSession.SessionType map(TestRunInfo.SessionType type) {
        return TestSession.SessionType.valueOf((String)type.name());
    }

    private static final class CallStackCallback
    implements JumpToCallStackAction.Callback {
        private final PhpProject project;

        public CallStackCallback(PhpProject project) {
            assert (project != null);
            this.project = project;
        }

        @Override
        public Locations.Line parseLocation(String callStack) {
            List<PhpTestingProvider> providers = this.project.getTestingProviders();
            if (providers.isEmpty()) {
                PhpProjectUtils.openCustomizer(this.project, "Testing");
                return null;
            }
            for (PhpTestingProvider testingProvider : providers) {
                Locations.Line location = testingProvider.parseFileFromOutput(callStack);
                if (location == null) continue;
                return location;
            }
            return null;
        }
    }
}

