/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.TestDirectoriesPathSupport;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CustomizerSeleniumTesting
extends JPanel {
    private static final long serialVersionUID = -654768735165768L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final DefaultListModel<BasePathSupport.Item> seleniumTestDirectoriesPathListModel;
    private JButton addFolderButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private JLabel testDirsLabel;
    private JList<BasePathSupport.Item> testDirsList;
    private JScrollPane testDirsScrollPane;

    CustomizerSeleniumTesting(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        assert (category != null);
        assert (uiProps != null);
        this.category = category;
        this.uiProps = uiProps;
        this.seleniumTestDirectoriesPathListModel = uiProps.getSeleniumTestDirectoriesListModel();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initTestDirectories();
    }

    private void initTestDirectories() {
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public String getDirKey() {
                return CustomizerSeleniumTesting.class.getName();
            }

            @Override
            public File getCurrentDirectory() {
                return FileUtil.toFile((FileObject)CustomizerSeleniumTesting.this.uiProps.getProject().getProjectDirectory());
            }
        };
        this.testDirsList.setModel(this.seleniumTestDirectoriesPathListModel);
        this.testDirsList.setCellRenderer(this.uiProps.getSeleniumTestDirectoriesListRenderer());
        this.seleniumTestDirectoriesPathListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerSeleniumTesting.this.validateAndStore();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerSeleniumTesting.this.validateAndStore();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerSeleniumTesting.this.validateAndStore();
            }
        });
        PathUiSupport.EditMediator.register(this.uiProps.getProject(), this.testDirsList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel(), directoryHandler);
    }

    void validateAndStore() {
        this.validateData();
    }

    private void validateData() {
        assert (EventQueue.isDispatchThread());
        ValidationResult result = new TestDirectoriesPathSupport.Validator().validatePaths(this.uiProps.getProject(), this.convertToList(this.seleniumTestDirectoriesPathListModel)).getResult();
        if (result.hasErrors()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(" ");
        this.category.setValid(true);
    }

    private List<BasePathSupport.Item> convertToList(DefaultListModel<BasePathSupport.Item> listModel) {
        ArrayList<BasePathSupport.Item> items = new ArrayList<BasePathSupport.Item>(listModel.getSize());
        for (int i = 0; i < listModel.getSize(); ++i) {
            items.add(listModel.get(i));
        }
        return items;
    }

    private void initComponents() {
        this.testDirsLabel = new JLabel();
        this.testDirsScrollPane = new JScrollPane();
        this.testDirsList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.testDirsLabel, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.testDirsLabel.text"));
        this.testDirsScrollPane.setViewportView(this.testDirsList);
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.addFolderButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.removeButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.moveUpButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.moveDownButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.testDirsScrollPane, -1, 277, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addFolderButton, GroupLayout.Alignment.TRAILING).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING).addComponent(this.moveUpButton, GroupLayout.Alignment.TRAILING).addComponent(this.moveDownButton, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.testDirsLabel).addGap(0, 242, Short.MAX_VALUE)));
        layout.linkSize(0, this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.testDirsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testDirsScrollPane, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton))).addContainerGap()));
    }
}

