/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.modules.php.dbgp.breakpoints.Bundle;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.ui.DbgpLineBreakpointCustomizer;
import org.netbeans.modules.php.dbgp.ui.DbgpLineBreakpointCustomizerPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BrkptsViewActionProvider
implements NodeActionsProviderFilter {
    private static final String GO_TO_SOURCE_LABEL = "CTL_Breakpoint_GoToSource_Label";
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getMessage(BrkptsViewActionProvider.class, (String)"CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new GoToSourcePerformer(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)Bundle.CTL_Breakpoint_Customize_Label(), (Models.ActionPerformer)new CustomizePerformer(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        if (node instanceof LineBreakpoint) {
            Action[] newActions = new Action[actions.length + 4];
            newActions[0] = GO_TO_SOURCE_ACTION;
            newActions[1] = null;
            System.arraycopy(actions, 0, newActions, 2, actions.length);
            newActions[newActions.length - 2] = null;
            newActions[newActions.length - 1] = CUSTOMIZE_ACTION;
            actions = newActions;
        }
        return actions;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            BrkptsViewActionProvider.goToSource((LineBreakpoint)((Object)node));
        } else {
            original.performDefaultAction(node);
        }
    }

    private static void goToSource(LineBreakpoint breakpoint) {
        Line line = breakpoint.getLine();
        if (line != null) {
            line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
        }
    }

    private static void customize(LineBreakpoint lb) {
        Controller controller;
        DbgpLineBreakpointCustomizerPanel panel = DbgpLineBreakpointCustomizer.getCustomizerComponent(lb);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)panel);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        if ((controller = panel.getController()) == null) {
            return;
        }
        Controller[] cPtr = new Controller[]{controller};
        DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
        Dialog[] dialogPtr = new Dialog[1];
        PropertyChangeListener propertyChangeListener = e -> {
            if (e.getPropertyName().equals("errorNotification")) {
                Object v = e.getNewValue();
                String message = v == null ? null : v.toString();
                descriptorPtr[0].getNotificationLineSupport().setErrorMessage(message);
            } else if (e.getPropertyName().equals("valid")) {
                descriptorPtr[0].setValid(controller.isValid());
            }
        };
        controller.addPropertyChangeListener(propertyChangeListener);
        ActionListener buttonsActionListener = e -> {
            if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                boolean ok = cPtr[0].ok();
                if (ok) {
                    dialogPtr[0].setVisible(false);
                    cPtr[0].removePropertyChangeListener(propertyChangeListener);
                }
            } else {
                dialogPtr[0].setVisible(false);
                cPtr[0].removePropertyChangeListener(propertyChangeListener);
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.CTL_Breakpoint_Customizer_Title(), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
        descriptor.setClosingOptions(new Object[0]);
        descriptor.createNotificationLineSupport();
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.pack();
        descriptorPtr[0] = descriptor;
        dialogPtr[0] = d;
        d.setVisible(true);
    }

    private static class CustomizePerformer
    implements Models.ActionPerformer {
        private CustomizePerformer() {
        }

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BrkptsViewActionProvider.customize((LineBreakpoint)((Object)nodes[0]));
        }
    }

    private static class GoToSourcePerformer
    implements Models.ActionPerformer {
        private GoToSourcePerformer() {
        }

        public boolean isEnabled(Object arg) {
            return true;
        }

        public void perform(Object[] nodes) {
            BrkptsViewActionProvider.goToSource((LineBreakpoint)((Object)nodes[0]));
        }
    }
}

