/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PHPStanReportParser
extends DefaultHandler {
    private static final String PHP_EXT = ".php";
    private static final Logger LOGGER = Logger.getLogger(PHPStanReportParser.class.getName());
    private final List<Result> results = new ArrayList<Result>();
    private final XMLReader xmlReader = FileUtils.createXmlReader();
    private Result currentResult = null;
    private String currentFile = null;
    private final FileObject root;
    @NullAllowed
    private final FileObject workDir;

    private PHPStanReportParser(FileObject root, @NullAllowed FileObject workDir) throws SAXException {
        this.root = root;
        this.workDir = workDir;
    }

    private static PHPStanReportParser create(Reader reader, FileObject root, @NullAllowed FileObject workDir) throws SAXException, IOException {
        PHPStanReportParser parser = new PHPStanReportParser(root, workDir);
        parser.xmlReader.setContentHandler(parser);
        parser.xmlReader.parse(new InputSource(reader));
        return parser;
    }

    @CheckForNull
    public static List<Result> parse(File file, FileObject root, @NullAllowed FileObject workDir) {
        List<Result> list;
        PHPStanReportParser.sanitizeFile(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            list = PHPStanReportParser.create(reader, root, workDir).getResults();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return null;
            }
        }
        ((Reader)reader).close();
        return list;
    }

    private static void sanitizeFile(File file) throws IOException {
        String fileName = file.getAbsolutePath();
        ArrayList<String> newLines = new ArrayList<String>();
        boolean content = false;
        List<String> readAllLines = Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8);
        if (!readAllLines.isEmpty() && readAllLines.get(0).startsWith("<?xml")) {
            return;
        }
        for (String line : readAllLines) {
            if (!content) {
                if (!line.startsWith("<?xml")) continue;
                content = true;
                continue;
            }
            if (!content) continue;
            newLines.add(line);
            if (!line.equals("</checkstyle>")) continue;
            break;
        }
        Files.write(Paths.get(fileName, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileStart(attributes);
        } else if ("error".equals(qName) && this.currentFile != null) {
            this.processResultStart(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileEnd();
        } else if ("error".equals(qName)) {
            this.processResultEnd();
        }
    }

    private void processFileStart(Attributes attributes) {
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        assert (this.currentFile == null) : this.currentFile;
        String name = attributes.getValue("name");
        this.currentFile = name == null ? null : this.getCurrentFile(name);
    }

    private void processFileEnd() {
        this.currentFile = null;
    }

    private void processResultStart(Attributes attributes) {
        assert (this.currentFile != null);
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        if (this.currentFile == null) {
            return;
        }
        this.currentResult = new Result(this.currentFile);
        int lineNumber = this.getInt(attributes, "line");
        if (lineNumber == 0) {
            lineNumber = 1;
        }
        this.currentResult.setLine(lineNumber);
        this.currentResult.setColumn(this.getInt(attributes, "column"));
        String message = attributes.getValue("message");
        this.currentResult.setCategory(String.format("%s: %s", attributes.getValue("severity"), message));
        this.currentResult.setDescription(message);
    }

    private void processResultEnd() {
        if (this.currentResult != null) {
            this.results.add(this.currentResult);
        }
        this.currentResult = null;
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.valueOf(attributes.getValue(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    @CheckForNull
    private String getCurrentFile(String fileName) {
        String sanitizedFileName = this.sanitizeFileName(fileName);
        File file = new File(sanitizedFileName);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        String currentFilePath = sanitizedFileName;
        FileObject rootDirectory = this.root;
        if (!this.root.isFolder()) {
            rootDirectory = this.root.getParent();
        }
        if (rootDirectory.isFolder()) {
            FileObject current = rootDirectory.getFileObject(sanitizedFileName = sanitizedFileName.replace('\\', '/'));
            if (current == null && this.workDir != null) {
                rootDirectory = this.workDir;
                current = rootDirectory.getFileObject(sanitizedFileName);
            }
            if (current == null) {
                LOGGER.log(Level.WARNING, "Cannot get the current file: file name {0}, root directory {1}", new Object[]{fileName, FileUtil.toFile((FileObject)rootDirectory).getAbsolutePath()});
                currentFilePath = null;
            } else {
                currentFilePath = FileUtil.toFile((FileObject)current).getAbsolutePath();
            }
        }
        return currentFilePath;
    }

    private String sanitizeFileName(String fileName) {
        int lastIndexOfPhpExt;
        if (!fileName.endsWith(PHP_EXT) && (lastIndexOfPhpExt = fileName.lastIndexOf(PHP_EXT)) != -1) {
            return fileName.substring(0, lastIndexOfPhpExt + PHP_EXT.length());
        }
        return fileName;
    }

    public List<Result> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

