/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.Bundle;
import org.netbeans.modules.php.analysis.PHPStanParams;
import org.netbeans.modules.php.analysis.commands.PHPStan;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.ui.analyzer.PHPStanCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.analysis.util.Mappers;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PHPStanAnalyzerImpl
implements Analyzer {
    private static final Logger LOGGER = Logger.getLogger(PHPStanAnalyzerImpl.class.getName());
    private final Analyzer.Context context;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    public PHPStanAnalyzerImpl(Analyzer.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        Preferences settings = this.context.getSettings();
        if (settings != null && !settings.getBoolean("phpStan.enabled", false)) {
            return Collections.emptyList();
        }
        PHPStan phpStan = this.getValidPHPStan();
        if (phpStan == null) {
            this.context.reportAnalysisProblem(Bundle.PHPStanAnalyzerImpl_phpStan_error(), (CharSequence)Bundle.PHPStanAnalyzerImpl_phpStan_error_description());
            return Collections.emptyList();
        }
        PHPStanParams phpStanParams = new PHPStanParams().setLevel(this.getValidPHPStanLevel()).setConfiguration(this.getValidPHPStanConfiguration()).setMemoryLimit(this.getValidPHPStanMemoryLimit());
        Scope scope = this.context.getScope();
        Map<FileObject, Integer> fileCount = AnalysisUtils.countPhpFiles(scope);
        int totalCount = 0;
        for (Integer count : fileCount.values()) {
            totalCount += count.intValue();
        }
        this.context.start(totalCount);
        try {
            Iterable<? extends ErrorDescription> iterable = this.doAnalyze(scope, phpStan, phpStanParams, fileCount);
            return iterable;
        }
        finally {
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private Iterable<? extends ErrorDescription> doAnalyze(Scope scope, PHPStan phpStan, PHPStanParams params, Map<FileObject, Integer> fileCount) {
        List<Result> results;
        ArrayList<Object> errors = new ArrayList<Object>();
        int progress = 0;
        phpStan.startAnalyzeGroup();
        for (FileObject root : scope.getSourceRoots()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = phpStan.analyze(params, root);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.PHPStanAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PHPStanAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(root).intValue());
        }
        for (FileObject file : scope.getFiles()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = phpStan.analyze(params, file);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.PHPStanAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PHPStanAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(file).intValue());
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            FileObject folder = nonRecursiveFolder.getFolder();
            List<Result> results2 = phpStan.analyze(params, folder);
            if (results2 == null) {
                this.context.reportAnalysisProblem(Bundle.PHPStanAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PHPStanAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results2));
            this.context.progress(progress += fileCount.get(folder).intValue());
        }
        return errors;
    }

    @CheckForNull
    private PHPStan getValidPHPStan() {
        try {
            return PHPStan.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private String getValidPHPStanLevel() {
        String phpStanLevel = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            phpStanLevel = settings.get("phpStan.level", null);
        }
        if (phpStanLevel == null) {
            phpStanLevel = AnalysisOptions.getInstance().getPHPStanLevel();
        }
        assert (phpStanLevel != null);
        return AnalysisOptions.getValidPHPStanLevel(phpStanLevel);
    }

    @CheckForNull
    private FileObject getValidPHPStanConfiguration() {
        String phpStanConfiguration = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            phpStanConfiguration = settings.get("phpStan.configuration", null);
        }
        if (phpStanConfiguration == null) {
            phpStanConfiguration = AnalysisOptions.getInstance().getPHPStanConfigurationPath();
        }
        if (StringUtils.isEmpty(phpStanConfiguration)) {
            return null;
        }
        return FileUtil.toFileObject((File)new File(phpStanConfiguration));
    }

    private String getValidPHPStanMemoryLimit() {
        Preferences settings = this.context.getSettings();
        String memoryLimit = settings != null ? settings.get("phpStan.memory.limit", "") : String.valueOf(AnalysisOptions.getInstance().getPHPStanMemoryLimit());
        assert (memoryLimit != null);
        return memoryLimit;
    }

    public static final class PHPStanAnalyzerFactory
    extends Analyzer.AnalyzerFactory {
        private static final String ICON_PATH = "org/netbeans/modules/php/analysis/ui/resources/phpstan.png";

        public PHPStanAnalyzerFactory() {
            super("PHPStan", Bundle.PHPStanAnalyzerFactory_displayName(), ICON_PATH);
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptyList();
        }

        public Analyzer.CustomizerProvider<Void, PHPStanCustomizerPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, PHPStanCustomizerPanel>(){

                public Void initialize() {
                    return null;
                }

                public PHPStanCustomizerPanel createComponent(Analyzer.CustomizerContext<Void, PHPStanCustomizerPanel> context) {
                    return new PHPStanCustomizerPanel(context);
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new PHPStanAnalyzerImpl(context);
        }

        public void warningOpened(ErrorDescription warning) {
            HintsController.setErrors((FileObject)warning.getFile(), (String)"phpStanWarning", Collections.singleton(warning));
        }
    }
}

