/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api;

import java.time.LocalDate;
import org.netbeans.modules.php.api.Bundle;

public final class PhpVersion
extends Enum<PhpVersion> {
    public static final /* enum */ PhpVersion PHP_5 = new PhpVersion(Bundle.PhpVersion_PHP_5(), false);
    public static final /* enum */ PhpVersion PHP_53 = new PhpVersion(Bundle.PhpVersion_PHP_53());
    public static final /* enum */ PhpVersion PHP_54 = new PhpVersion(Bundle.PhpVersion_PHP_54());
    public static final /* enum */ PhpVersion PHP_55 = new PhpVersion(Bundle.PhpVersion_PHP_55());
    public static final /* enum */ PhpVersion PHP_56 = new PhpVersion(Bundle.PhpVersion_PHP_56());
    public static final /* enum */ PhpVersion PHP_70 = new PhpVersion(Bundle.PhpVersion_PHP_70());
    public static final /* enum */ PhpVersion PHP_71 = new PhpVersion(Bundle.PhpVersion_PHP_71());
    public static final /* enum */ PhpVersion PHP_72 = new PhpVersion(Bundle.PhpVersion_PHP_72());
    public static final /* enum */ PhpVersion PHP_73 = new PhpVersion(Bundle.PhpVersion_PHP_73());
    public static final /* enum */ PhpVersion PHP_74 = new PhpVersion(Bundle.PhpVersion_PHP_74());
    private final String displayName;
    private final boolean namespaces;
    private static final /* synthetic */ PhpVersion[] $VALUES;

    public static PhpVersion[] values() {
        return (PhpVersion[])$VALUES.clone();
    }

    public static PhpVersion valueOf(String name) {
        return Enum.valueOf(PhpVersion.class, name);
    }

    private PhpVersion(String displayName) {
        this(displayName, true);
    }

    private PhpVersion(String displayName, boolean namespaces) {
        assert (displayName != null);
        this.displayName = displayName;
        this.namespaces = namespaces;
    }

    public static PhpVersion getDefault() {
        PhpVersion[] phpVersions = PhpVersion.values();
        return phpVersions[phpVersions.length - 1];
    }

    public static PhpVersion getLegacy() {
        PhpVersion[] phpVersions;
        for (PhpVersion phpVersion : phpVersions = PhpVersion.values()) {
            if (!phpVersion.isSupportedVersion()) continue;
            return phpVersion;
        }
        return phpVersions[phpVersions.length - 2];
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean hasNamespaces() {
        return this.namespaces;
    }

    public boolean hasScalarAndReturnTypes() {
        return this.compareTo(PHP_70) >= 0;
    }

    public boolean hasNullableTypes() {
        return this.compareTo(PHP_71) >= 0;
    }

    public boolean hasVoidReturnType() {
        return this.compareTo(PHP_71) >= 0;
    }

    public boolean hasPropertyTypes() {
        return this.compareTo(PHP_74) >= 0;
    }

    public boolean isSupportedVersion() {
        return Period.valueOf(this.name()).isSupportedVersion();
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        $VALUES = new PhpVersion[]{PHP_5, PHP_53, PHP_54, PHP_55, PHP_56, PHP_70, PHP_71, PHP_72, PHP_73, PHP_74};
    }

    private static enum Period {
        PHP_5(LocalDate.of(2005, 11, 24), LocalDate.of(2011, 1, 6), LocalDate.of(2011, 1, 6)),
        PHP_53(LocalDate.of(2009, 6, 30), LocalDate.of(2014, 8, 14), LocalDate.of(2014, 8, 14)),
        PHP_54(LocalDate.of(2012, 3, 1), LocalDate.of(2014, 9, 14), LocalDate.of(2014, 9, 14)),
        PHP_55(LocalDate.of(2013, 6, 20), LocalDate.of(2015, 7, 10), LocalDate.of(2015, 7, 10)),
        PHP_56(LocalDate.of(2014, 8, 28), LocalDate.of(2017, 1, 19), LocalDate.of(2018, 12, 31)),
        PHP_70(LocalDate.of(2015, 12, 3), LocalDate.of(2017, 12, 3), LocalDate.of(2018, 12, 3)),
        PHP_71(LocalDate.of(2016, 12, 1), LocalDate.of(2018, 12, 1), LocalDate.of(2019, 12, 1)),
        PHP_72(LocalDate.of(2017, 11, 30), LocalDate.of(2019, 11, 30), LocalDate.of(2020, 11, 30)),
        PHP_73(LocalDate.of(2018, 12, 6), LocalDate.of(2020, 12, 6), LocalDate.of(2021, 12, 6)),
        PHP_74(LocalDate.of(2019, 11, 28), LocalDate.of(2021, 11, 28), LocalDate.of(2022, 11, 28));

        private final LocalDate initialRelease;
        private final LocalDate activeSupport;
        private final LocalDate securitySupport;

        private Period(LocalDate initialRelease, LocalDate activeSupport, LocalDate securitySupport) {
            this.initialRelease = initialRelease;
            this.activeSupport = activeSupport;
            this.securitySupport = securitySupport;
        }

        public LocalDate getInitialRelease() {
            return this.initialRelease;
        }

        public LocalDate getActiveSupport() {
            return this.activeSupport;
        }

        public LocalDate getSecuritySupport() {
            return this.securitySupport;
        }

        public boolean isSupportedVersion() {
            return LocalDate.now().isBefore(this.securitySupport);
        }
    }
}

