/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.payara.tooling.server.config.ServerConfigException;

public enum JavaEEProfile {
    v1_2(Version.v1_2, Type.FULL, "1.2"),
    v1_3(Version.v1_3, Type.FULL, "1.3"),
    v1_4(Version.v1_4, Type.FULL, "1.4"),
    v1_5(Version.v1_5, Type.FULL, "1.5"),
    v1_6_web(Version.v1_6, Type.WEB, "1.6-web"),
    v1_6(Version.v1_6, Type.FULL, "1.6"),
    v1_7_web(Version.v1_7, Type.WEB, "1.7-web"),
    v1_7(Version.v1_7, Type.FULL, "1.7"),
    v1_8_web(Version.v1_8, Type.WEB, "1.8-web"),
    v1_8(Version.v1_8, Type.FULL, "1.8"),
    v8_0_0_web(Version.v8_0_0, Type.WEB, "8.0.0-web"),
    v8_0_0(Version.v8_0_0, Type.FULL, "8.0.0"),
    v9_0_0_web(Version.v9_0_0, Type.WEB, "9.0.0-web"),
    v9_0_0(Version.v9_0_0, Type.FULL, "9.0.0"),
    v9_1_0_web(Version.v9_1_0, Type.WEB, "9.1.0-web"),
    v9_1_0(Version.v9_1_0, Type.FULL, "9.1.0");

    public static final int length;
    public static final char TYPE_SEPARATOR = '-';
    private static final Map<String, JavaEEProfile> stringValuesMap;
    private final Version version;
    private final Type type;
    private final String name;

    private static String[] createNames(JavaEEProfile profile) throws ServerConfigException {
        String[] names;
        StringBuilder sb = new StringBuilder(profile.version.toString().length() + 1 + profile.type.toString().length());
        sb.append(profile.version.toString());
        sb.append('-');
        sb.append(profile.type.toString());
        switch (profile.type) {
            case FULL: {
                names = new String[]{profile.version.toString(), sb.toString()};
                break;
            }
            case WEB: {
                names = new String[]{sb.toString()};
                break;
            }
            default: {
                throw new ServerConfigException("Invalid Payara JavaEE profile type");
            }
        }
        return names;
    }

    public static JavaEEProfile toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public static JavaEEProfile toValue(String version, String type) {
        if (version != null && type != null) {
            StringBuilder sb = new StringBuilder(version.length() + 1 + type.length());
            sb.append(version);
            sb.append('-');
            sb.append(type);
            return stringValuesMap.get(sb.toString().toUpperCase());
        }
        return null;
    }

    private JavaEEProfile(Version version, Type type, String name) {
        this.version = version;
        this.type = type;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    static {
        length = JavaEEProfile.values().length;
        stringValuesMap = new HashMap<String, JavaEEProfile>(JavaEEProfile.values().length);
        for (JavaEEProfile profile : JavaEEProfile.values()) {
            String[] names;
            for (String name : names = JavaEEProfile.createNames(profile)) {
                stringValuesMap.put(name.toUpperCase(), profile);
            }
        }
    }

    public static enum Version {
        v1_2("1.2"),
        v1_3("1.3"),
        v1_4("1.4"),
        v1_5("1.5"),
        v1_6("1.6"),
        v1_7("1.7"),
        v1_8("1.8"),
        v8_0_0("8.0.0"),
        v9_0_0("9.0.0"),
        v9_1_0("9.1.0");

        private final String name;

        private Version(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Type {
        WEB("web"),
        FULL("full");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

