/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.data.PayaraConfig;
import org.netbeans.modules.payara.tooling.data.PayaraJavaEEConfig;
import org.netbeans.modules.payara.tooling.data.PayaraJavaSEConfig;
import org.netbeans.modules.payara.tooling.data.PayaraLibrary;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.server.config.Config;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.modules.payara.tooling.server.config.ConfigUtils;
import org.netbeans.modules.payara.tooling.server.config.LibraryNode;
import org.netbeans.modules.payara.tooling.server.config.PayaraConfigManager;
import org.netbeans.modules.payara.tooling.server.config.ServerConfigException;

public class ConfigBuilder {
    private final Config config;
    private final File classpathHome;
    private final File javadocsHome;
    private final File srcHome;
    private List<PayaraLibrary> libraryCache;
    private PayaraJavaEEConfig javaEEConfigCache;
    private PayaraJavaSEConfig javaSEConfigCache;
    private PayaraVersion version;

    private static List<PayaraLibrary> getLibraries(List<LibraryNode> libConfigs, File classpathHome, File javadocsHome, File srcHome) {
        LinkedList<PayaraLibrary> result = new LinkedList<PayaraLibrary>();
        try {
            for (LibraryNode libConfig : libConfigs) {
                List<File> classpath = ConfigUtils.processFileset(libConfig.classpath, classpathHome.getAbsolutePath());
                List<File> javadocs = ConfigUtils.processFileset(libConfig.javadocs, javadocsHome.getAbsolutePath());
                List<URL> javadocUrls = ConfigUtils.processLinks(libConfig.javadocs);
                List<File> sources = ConfigUtils.processFileset(libConfig.sources, srcHome.getAbsolutePath());
                result.add(new PayaraLibrary(libConfig.libraryID, ConfigBuilder.buildUrls(classpath), ConfigBuilder.buildUrls(javadocs, javadocUrls), libConfig.javadocs.getLookups(), ConfigBuilder.buildUrls(sources), ConfigUtils.processClassPath(classpath)));
            }
        }
        catch (FileNotFoundException e) {
            throw new PayaraIdeException("Some files required by configuration were not found.", e);
        }
        return result;
    }

    private static List<URL> buildUrls(List<File> files, List<URL> urls) {
        List<URL> result = ConfigBuilder.buildUrls(files);
        result.addAll(urls);
        return result;
    }

    private static List<URL> buildUrls(List<File> files) {
        ArrayList<URL> result = new ArrayList<URL>(files.size());
        for (File file : files) {
            URL url = ConfigUtils.fileToURL(file);
            if (url == null) continue;
            result.add(url);
        }
        return result;
    }

    ConfigBuilder(Config config, String classpathHome, String javadocsHome, String srcHome) {
        this.config = config;
        this.classpathHome = new File(classpathHome);
        this.javadocsHome = new File(javadocsHome);
        this.srcHome = new File(srcHome);
    }

    ConfigBuilder(Config config, File classpathHome, File javadocsHome, File srcHome) {
        this.config = config;
        this.classpathHome = classpathHome;
        this.javadocsHome = javadocsHome;
        this.srcHome = srcHome;
    }

    private synchronized void versionCheck(PayaraVersion version) throws ServerConfigException {
        if (this.version == null) {
            this.version = version;
        } else if (this.version != version) {
            throw new ServerConfigException("Library builder was already used for Payara " + (Object)((Object)this.version) + " use new instance for Payara" + (Object)((Object)version));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PayaraLibrary> getLibraries(PayaraVersion version) throws ServerConfigException {
        this.versionCheck(version);
        ConfigBuilder configBuilder = this;
        synchronized (configBuilder) {
            if (this.libraryCache != null) {
                return this.libraryCache;
            }
            PayaraConfig configAdapter = PayaraConfigManager.getConfig(ConfigBuilderProvider.getBuilderConfig(version));
            List<LibraryNode> libConfigs = configAdapter.getLibrary();
            this.libraryCache = ConfigBuilder.getLibraries(libConfigs, this.classpathHome, this.javadocsHome, this.srcHome);
            return this.libraryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayaraJavaEEConfig getJavaEEConfig(PayaraVersion version) throws ServerConfigException {
        this.versionCheck(version);
        ConfigBuilder configBuilder = this;
        synchronized (configBuilder) {
            if (this.javaEEConfigCache != null) {
                return this.javaEEConfigCache;
            }
            PayaraConfig configAdapter = PayaraConfigManager.getConfig(ConfigBuilderProvider.getBuilderConfig(version));
            this.javaEEConfigCache = new PayaraJavaEEConfig(configAdapter.getJavaEE(), this.classpathHome);
            return this.javaEEConfigCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayaraJavaSEConfig getJavaSEConfig(PayaraVersion version) throws ServerConfigException {
        this.versionCheck(version);
        ConfigBuilder configBuilder = this;
        synchronized (configBuilder) {
            if (this.javaSEConfigCache != null) {
                return this.javaSEConfigCache;
            }
            PayaraConfig configAdapter = PayaraConfigManager.getConfig(ConfigBuilderProvider.getBuilderConfig(version));
            this.javaSEConfigCache = new PayaraJavaSEConfig(configAdapter.getJavaSE());
            return this.javaSEConfigCache;
        }
    }
}

