/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.net.Authenticator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.AdminFactory;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.Result;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.IdeContext;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

public class ServerAdmin {
    public static void init(Authenticator authenticator) {
        Runner.init(authenticator);
    }

    public static <E extends Result> Future<E> exec(PayaraServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(PayaraServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute();
    }

    public static ExecutorService executor(int size) {
        return Runner.parallelExecutor(size);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, PayaraServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, PayaraServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(PayaraServer srv, Command cmd) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(PayaraServer srv, Command cmd, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, PayaraServer srv, Command cmd) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, PayaraServer srv, Command cmd, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute(executor);
    }
}

