/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.spi.ExecSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class CreateDomain
extends Thread {
    static final String PORTBASE = "portbase";
    private final String uname;
    private final String pword;
    private final File platformLocation;
    private final Map<String, String> map;
    private final Map<String, String> instanceProperties;
    private final PayaraInstanceProvider instanceProvider;
    private final boolean register;
    private final String installRootKey;

    public CreateDomain(String uname, String pword, File platformLocation, Map<String, String> instanceProperties, PayaraInstanceProvider instanceProvider, boolean register, boolean useDefaultPorts, String installRootKey) {
        this.uname = uname;
        this.pword = pword;
        this.platformLocation = platformLocation;
        this.instanceProperties = instanceProperties;
        this.map = new HashMap<String, String>();
        this.instanceProvider = instanceProvider;
        this.map.putAll(instanceProperties);
        this.register = register;
        this.installRootKey = installRootKey;
        CreateDomain.computePorts(instanceProperties, this.map, useDefaultPorts);
    }

    private static void computePorts(Map<String, String> ip, Map<String, String> createProps, boolean useDefaultPorts) {
        int adminPort;
        int httpPort;
        int portBase = 8900;
        int kicker = (new Date().toString() + ip.get("domainsfolder") + ip.get("domainname")).hashCode() % 40000;
        int n = kicker = kicker < 0 ? -kicker : kicker;
        if (useDefaultPorts) {
            httpPort = 8080;
            adminPort = 4848;
        } else {
            httpPort = ip.get("httpportnumber") != null ? Integer.parseInt(ip.get("httpportnumber")) : portBase + kicker + 80;
            adminPort = ip.get("adminPort") != null ? Integer.parseInt(ip.get("adminPort")) : portBase + kicker + 48;
        }
        ip.put("httpportnumber", Integer.toString(httpPort));
        ip.put("adminPort", Integer.toString(adminPort));
        createProps.put("httpportnumber", Integer.toString(httpPort));
        createProps.put("adminPort", Integer.toString(adminPort));
    }

    @Override
    public void run() {
        Process process = null;
        File irf = this.platformLocation;
        int retVal = 0;
        if (null != irf && irf.exists()) {
            String startScript = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java";
            if ("\\".equals(File.separator)) {
                startScript = startScript + ".exe";
            }
            File jar = new File(irf, "modules" + File.separator + "admin-cli.jar");
            String jarLocation = jar.getAbsolutePath();
            String domain = this.map.get("domainname");
            String domainDir = this.map.get("domainsfolder");
            File passWordFile = CreateDomain.createTempPasswordFile(this.pword, "changeit");
            String adminPort = this.instanceProperties.get("adminPort");
            String httpPort = this.instanceProperties.get("httpportnumber");
            if (passWordFile == null) {
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(startScript, "-client", "-jar", jarLocation, "create-domain", "--domaindir", domainDir, "--user", this.uname));
            if ("".equals(this.pword) && this.instanceProvider.getNoPasswordOptions().size() > 0) {
                args.addAll(this.instanceProvider.getNoPasswordOptions());
            } else {
                args.add("--passwordfile");
                args.add(passWordFile.getAbsolutePath());
            }
            if (null != this.map.get(PORTBASE)) {
                args.add("--portbase");
                args.add(this.map.get(PORTBASE));
            } else {
                args.add("--adminport");
                args.add(adminPort);
                args.add("--instanceport");
                args.add(httpPort);
            }
            args.add(domain);
            ProgressHandle ph = null;
            try {
                ExecSupport ee = new ExecSupport();
                process = Runtime.getRuntime().exec(args.toArray(new String[0]), null, irf);
                PDCancel pdcan = new PDCancel(process, domainDir + File.separator + domain);
                ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"LBL_Creating_personal_domain"), (Cancellable)pdcan);
                ph.start();
                ee.displayProcessOutputs(process, NbBundle.getMessage(this.getClass(), (String)"LBL_outputtab"), NbBundle.getMessage(this.getClass(), (String)"LBL_RunningCreateDomainCommand"));
            }
            catch (IOException | InterruptedException | MissingResourceException ex) {
                CreateDomain.showInformation(ex.getLocalizedMessage());
            }
            catch (RuntimeException ex) {
                CreateDomain.showInformation(ex.getLocalizedMessage());
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            if (null != process) {
                try {
                    retVal = process.waitFor();
                    if (!passWordFile.delete()) {
                        CreateDomain.showInformation(NbBundle.getMessage(this.getClass(), (String)"MSG_delete_password_failed", (Object)passWordFile.getAbsolutePath()));
                    }
                }
                catch (InterruptedException ie) {
                    retVal = -1;
                    ErrorManager.getDefault().notify(1, (Throwable)ie);
                }
            } else {
                retVal = -1;
            }
            if (null != ph) {
                ph.finish();
            }
            if (0 == retVal) {
                if (this.register) {
                    PayaraInstance ie = PayaraInstance.create(this.instanceProperties, this.instanceProvider);
                }
            } else if (this.register) {
                NbPreferences.forModule(this.getClass()).put("first_run" + this.installRootKey, "false");
            }
            String mess = 0 == retVal ? NbBundle.getMessage(this.getClass(), (String)"MSG_see_successful_results") : NbBundle.getMessage(this.getClass(), (String)"MSG_see_failure_results");
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)mess, 0));
            if (NotifyDescriptor.YES_OPTION.equals(ret)) {
                InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(this.getClass(), (String)"LBL_outputtab"), false);
                io.select();
            }
        }
    }

    public int getHttpPort() {
        return Integer.parseInt(this.instanceProperties.get("httpportnumber"));
    }

    public int getAdminPort() {
        return Integer.parseInt(this.instanceProperties.get("adminPort"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempPasswordFile(String password, String masterPassword) {
        File retVal = null;
        try (PrintWriter p = null;){
            retVal = File.createTempFile("admin", null);
            retVal.deleteOnExit();
            FileOutputStream output = new FileOutputStream(retVal);
            p = new PrintWriter(output);
            p.println("AS_ADMIN_ADMINPASSWORD=" + password);
            p.println("AS_ADMIN_PASSWORD=" + password);
            p.println("AS_ADMIN_MASTERPASSWORD=" + masterPassword);
        }
        return retVal;
    }

    private static void showInformation(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    private static void showError(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    static class PDCancel
    implements Cancellable {
        private final Process p;
        private final String dirname;
        private boolean notFired = true;

        PDCancel(Process p, String newDirName) {
            this.p = p;
            this.dirname = newDirName;
        }

        public synchronized boolean isNotFired() {
            return this.notFired;
        }

        public synchronized boolean cancel() {
            this.notFired = false;
            this.p.destroy();
            File domainDir = new File(this.dirname);
            if (domainDir.exists()) {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)domainDir));
                try {
                    fo.delete();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", ex);
                    CreateDomain.showError(NbBundle.getMessage(PayaraInstanceProvider.class, (String)"ERR_Failed_cleanup", (Object)this.dirname));
                }
            }
            return true;
        }
    }
}

