/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.netserver.SocketFramework;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;

abstract class AbstractWSHandler75<T extends SocketFramework>
extends AbstractWSHandler<T>
implements WebSocketChanelHandler {
    AbstractWSHandler75(T framework) {
        super(framework);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.getKey().channel();
        byte[] bytes = new byte[1000];
        LinkedList messages = new LinkedList();
        LinkedList<Byte> message = new LinkedList<Byte>();
        boolean newMessage = false;
        while (!this.isStopped()) {
            byteBuffer.clear();
            if (socketChannel.read(byteBuffer) == -1) {
                this.close();
                return;
            }
            byteBuffer.flip();
            byteBuffer.get(bytes, 0, byteBuffer.limit());
            int start = 0;
            if (bytes[0] == 0 && !newMessage) {
                start = 1;
                newMessage = true;
                if (!message.isEmpty()) {
                    messages.add(new ArrayList(message));
                }
                message.clear();
            }
            for (int i = start; i < byteBuffer.limit(); ++i) {
                if (bytes[i] == -1) {
                    messages.add(new ArrayList(message));
                    message.clear();
                    newMessage = false;
                    continue;
                }
                message.add(bytes[i]);
            }
            if (!message.isEmpty()) continue;
            break;
        }
        if (this.isStopped()) {
            this.close();
            return;
        }
        for (List list : messages) {
            bytes = new byte[list.size()];
            int i = 0;
            for (Byte byt : list) {
                bytes[i] = byt;
                ++i;
            }
            this.readDelegate(bytes);
        }
    }

    @Override
    public byte[] createTextFrame(String message) {
        byte[] data = message.getBytes(Charset.forName("UTF-8"));
        byte[] result = new byte[data.length + 2];
        result[0] = 0;
        result[data.length + 1] = -1;
        System.arraycopy(data, 0, result, 1, data.length);
        return result;
    }

    protected byte[] readRequestContent(int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        SocketChannel socketChannel = (SocketChannel)this.getKey().channel();
        try {
            while (buffer.hasRemaining() && !this.isStopped()) {
                if (socketChannel.read(buffer) != -1) continue;
                this.close();
            }
            if (this.isStopped()) {
                this.close();
                return null;
            }
            byte[] bytes = new byte[buffer.capacity()];
            buffer.flip();
            buffer.get(bytes);
            return bytes;
        }
        catch (IOException e) {
            this.close();
            return null;
        }
    }

    protected abstract void readDelegate(byte[] var1);
}

