/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.maven.model.settings.SettingsModelFactory;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());

    private Utilities() {
    }

    public static ModelSource createModelSourceForMissingFile(File file, boolean editable, String skeleton, String mimeType) {
        try {
            BaseDocument doc = new BaseDocument(false, mimeType);
            doc.insertString(0, skeleton, null);
            InstanceContent ic = new InstanceContent();
            AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)ic);
            ic.add((Object)file);
            ic.add((Object)doc);
            ModelSource ms = new ModelSource((Lookup)lookup, editable);
            return ms;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            assert (false) : "Failed to load the model for non-existing file";
            return null;
        }
    }

    private static BaseDocument getDocument(DataObject modelSourceDataObject) throws IOException {
        if (modelSourceDataObject != null && modelSourceDataObject.isValid()) {
            StyledDocument doc;
            EditorCookie ec = (EditorCookie)modelSourceDataObject.getLookup().lookup(EditorCookie.class);
            assert (ec != null) : "Data object " + modelSourceDataObject.getPrimaryFile().getPath() + " has no editor cookies.";
            try {
                doc = ec.openDocument();
            }
            catch (UserQuestionException uce) {
                uce.confirmed();
                doc = ec.openDocument();
            }
            if (doc instanceof BaseDocument) {
                return (BaseDocument)doc;
            }
            logger.log(Level.FINER, "Got document of unexpected {0} from {1}", new Object[]{doc.getClass(), modelSourceDataObject});
            GuardedDocument doc2 = new GuardedDocument("text/xml");
            try {
                String str = doc.getText(0, doc.getLength());
                doc2.insertString(0, str, null);
            }
            catch (BadLocationException x) {
                throw new IOException(x);
            }
            final StyledDocument orig = doc;
            doc2.addDocumentListener(new DocumentListener((BaseDocument)doc2){
                final /* synthetic */ BaseDocument val$doc2;
                {
                    this.val$doc2 = baseDocument;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    block2: {
                        try {
                            orig.insertString(e.getOffset(), this.val$doc2.getText(e.getOffset(), e.getLength()), null);
                        }
                        catch (BadLocationException x) {
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError((Object)x);
                        }
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    block2: {
                        try {
                            orig.remove(e.getOffset(), e.getLength());
                        }
                        catch (BadLocationException x) {
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError((Object)x);
                        }
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            doc2.putProperty((Object)"stream", doc.getProperty("stream"));
            return doc2;
        }
        return null;
    }

    public static ModelSource createModelSource(FileObject thisFileObj) {
        return Utilities.createModelSource(thisFileObj, null, null);
    }

    public static ModelSource createModelSource(final FileObject thisFileObj, final DataObject dobject, final BaseDocument document) {
        assert (thisFileObj != null) : "Null file object.";
        final File fl = FileUtil.toFile((FileObject)thisFileObj);
        boolean editable = fl != null;
        Lookup proxyLookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(thisFileObj);
                try {
                    BaseDocument doc;
                    DataObject dobj = dobject != null ? dobject : DataObject.find((FileObject)thisFileObj);
                    items.add(dobj);
                    BaseDocument baseDocument = doc = document != null ? document : Utilities.getDocument(dobj);
                    if (doc != null) {
                        items.add(doc);
                    } else {
                        logger.log(Level.WARNING, "no Document found for {0}", dobj);
                    }
                }
                catch (IOException x) {
                    logger.log(Level.SEVERE, x.getMessage());
                }
                if (fl != null) {
                    items.add(fl);
                }
                return Lookups.fixed((Object[])items.toArray());
            }
        });
        return new ModelSource(proxyLookup, editable);
    }

    public static void saveChanges(AbstractDocumentModel<?> model) throws IOException {
        if (model.isIntransaction()) {
            model.endTransaction();
        }
        model.sync();
        DataObject dobj = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dobj == null) {
            FileObject fParentFo;
            final Document doc = (Document)model.getModelSource().getLookup().lookup(Document.class);
            final File file = (File)model.getModelSource().getLookup().lookup(File.class);
            logger.log(Level.FINE, "saving changes in {0}", file);
            File parent = file.getParentFile();
            FileObject parentFo = FileUtil.toFileObject((File)parent);
            if (parentFo == null) {
                parent.mkdirs();
                FileUtil.refreshFor((File[])new File[]{parent});
                parentFo = FileUtil.toFileObject((File)parent);
            }
            if ((fParentFo = parentFo) != null) {
                FileSystem fs = parentFo.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        String text;
                        try {
                            text = doc.getText(0, doc.getLength());
                        }
                        catch (BadLocationException x) {
                            throw new IOException(x);
                        }
                        FileObject fo = fParentFo.getFileObject(file.getName());
                        if (fo == null) {
                            fo = fParentFo.createData(file.getName());
                        }
                        OutputStream os = fo.getOutputStream();
                        try {
                            os.write(text.getBytes("UTF-8"));
                        }
                        finally {
                            os.close();
                        }
                    }
                });
            }
        } else {
            SaveCookie save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
            if (save != null) {
                logger.log(Level.FINE, "saving changes in {0}", dobj);
                save.save();
            } else {
                logger.log(Level.FINE, "no changes in {0} where modified={1}", new Object[]{dobj, dobj.isModified()});
            }
        }
    }

    public static void performPOMModelOperations(FileObject pomFileObject, List<? extends ModelOperation<POMModel>> operations) {
        assert (pomFileObject != null);
        ModelSource source = Utilities.createModelSource(pomFileObject);
        Utilities.performPOMModelOperations(source, operations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performPOMModelOperations(final ModelSource source, List<? extends ModelOperation<POMModel>> operations) {
        assert (source != null);
        assert (operations != null);
        if (source.getLookup().lookup(BaseDocument.class) == null) {
            logger.log(Level.WARNING, "#193187: no Document associated with {0}", Utilities.getPathFromSource(source));
            return;
        }
        POMModel model = POMModelFactory.getDefault().getModel(source);
        if (model != null) {
            try {
                model.sync();
                if (Model.State.VALID != model.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                if (!model.startTransaction()) {
                    logger.log(Level.WARNING, "Could not start transaction on {0}", Utilities.getPathFromSource(source));
                    return;
                }
                final AtomicBoolean modified = new AtomicBoolean();
                ComponentListener listener = new ComponentListener(){

                    private void change(ComponentEvent evt) {
                        logger.log(Level.FINE, "{0}: {1}", new Object[]{Utilities.getPathFromSource(source), evt});
                        modified.set(true);
                    }

                    public void valueChanged(ComponentEvent evt) {
                        this.change(evt);
                    }

                    public void childrenAdded(ComponentEvent evt) {
                        this.change(evt);
                    }

                    public void childrenDeleted(ComponentEvent evt) {
                        this.change(evt);
                    }
                };
                model.addComponentListener(listener);
                try {
                    for (ModelOperation<POMModel> modelOperation : operations) {
                        modelOperation.performOperation(model);
                    }
                    model.endTransaction();
                }
                finally {
                    model.removeComponentListener(listener);
                }
                if (modified.get()) {
                    Utilities.saveChanges(model);
                }
                logger.log(Level.FINE, "no changes recorded in {0}", Utilities.getPathFromSource(source));
            }
            catch (IOException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                logger.log(Level.INFO, "Cannot write POM", ex);
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                logger.log(Level.INFO, "Cannot write POM", ex);
            }
            finally {
                if (model.isIntransaction()) {
                    model.rollbackTransaction();
                }
            }
        } else {
            logger.log(Level.WARNING, "Cannot create model from current content of {0}", Utilities.getPathFromSource(source));
        }
    }

    private static String getPathFromSource(ModelSource source) {
        File f = (File)source.getLookup().lookup(File.class);
        if (f != null) {
            return f.getAbsolutePath();
        }
        DataObject dob = (DataObject)source.getLookup().lookup(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile().getPath();
        }
        return source.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performSettingsModelOperations(FileObject settingsFileObject, List<? extends ModelOperation<SettingsModel>> operations) {
        assert (settingsFileObject != null);
        assert (operations != null);
        ModelSource source = Utilities.createModelSource(settingsFileObject);
        SettingsModel model = SettingsModelFactory.getDefault().getModel(source);
        if (model != null) {
            try {
                model.sync();
                if (Model.State.VALID != model.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_SETTINGS", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                if (!model.startTransaction()) {
                    logger.log(Level.WARNING, "Could not start transaction on {0}", settingsFileObject);
                    return;
                }
                for (ModelOperation<SettingsModel> modelOperation : operations) {
                    modelOperation.performOperation(model);
                }
                model.endTransaction();
                Utilities.saveChanges(model);
            }
            catch (IOException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_SETTINGS", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write settings.xml", ex);
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_SETTINGS", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write settings.xml", ex);
            }
            finally {
                if (model.isIntransaction()) {
                    model.rollbackTransaction();
                }
            }
        }
    }

    public static void openAtPosition(final POMModel model, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)offset, (boolean)false);
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.log(Level.FINE, "document changed", e);
                }
            }
        });
    }
}

