/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public final class StatusProvider
implements UpToDateStatusProviderFactory {
    private static final RequestProcessor RP = new RequestProcessor("StatusProvider");
    private static final Logger LOG = Logger.getLogger(StatusProvider.class.getName());

    public UpToDateStatusProvider createUpToDateStatusProvider(Document document) {
        return new StatusProviderImpl(document);
    }

    static class StatusProviderImpl
    extends UpToDateStatusProvider {
        private final Document document;
        @NullAllowed
        private POMModel model;
        private Project project;

        StatusProviderImpl(Document doc) {
            this.document = doc;
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.initializeModel();
                }
            });
        }

        private void initializeModel() {
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            if (fo != null) {
                ModelSource ms = Utilities.createModelSource((FileObject)fo, null, this.document instanceof BaseDocument ? (BaseDocument)this.document : null);
                this.model = (POMModel)POMModelFactory.getDefault().createFreshModel(ms);
                this.project = FileOwnerQuery.getOwner((FileObject)fo);
            }
        }

        public UpToDateStatus getUpToDate() {
            return UpToDateStatus.UP_TO_DATE_OK;
        }
    }
}

