/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixBase;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Pair;

public class RulesManager {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.maven.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-maven-hints";

    private RulesManager() {
    }

    public static TreeModel getHintsTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        DefaultTreeModel hintsTreeModel = new DefaultTreeModel(rootNode);
        FileObject folder = FileUtil.getConfigFile((String)RULES_FOLDER);
        List<Pair<POMErrorFixBase, FileObject>> rules = RulesManager.readRules(folder);
        RulesManager.categorizeTreeRules(rules, folder, rootNode);
        return hintsTreeModel;
    }

    private static List<Pair<POMErrorFixBase, FileObject>> readRules(FileObject folder) {
        LinkedList<Pair<POMErrorFixBase, FileObject>> rules = new LinkedList<Pair<POMErrorFixBase, FileObject>>();
        if (folder == null) {
            return rules;
        }
        LinkedList<FileObject> q = new LinkedList<FileObject>();
        q.offer(folder);
        while (!q.isEmpty()) {
            FileObject o = (FileObject)q.poll();
            if (o.isFolder()) {
                q.addAll(Arrays.asList(o.getChildren()));
                continue;
            }
            if (!o.isData()) continue;
            String name = o.getNameExt().toLowerCase();
            if (!o.canRead()) continue;
            POMErrorFixBase r = null;
            if (name.endsWith(INSTANCE_EXT)) {
                r = RulesManager.instantiateRule(o);
            }
            if (r == null) continue;
            rules.add((Pair<POMErrorFixBase, FileObject>)Pair.of((Object)r, (Object)o));
        }
        return rules;
    }

    private static void categorizeTreeRules(List<Pair<POMErrorFixBase, FileObject>> rules, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<POMErrorFixBase, FileObject> pair : rules) {
            FileObject parent;
            DefaultMutableTreeNode category;
            POMErrorFixBase rule = (POMErrorFixBase)pair.first();
            FileObject fo = (FileObject)pair.second();
            Object nonGuiObject = fo.getAttribute(NON_GUI);
            boolean toGui = true;
            if (nonGuiObject != null && nonGuiObject instanceof Boolean && ((Boolean)nonGuiObject).booleanValue()) {
                toGui = false;
            }
            if ((category = (DefaultMutableTreeNode)dir2node.get(parent = fo.getParent())) == null) {
                category = new DefaultMutableTreeNode(parent);
                rootNode.add(category);
                dir2node.put(parent, category);
            }
            if (!toGui) continue;
            category.add(new DefaultMutableTreeNode(rule, false));
        }
    }

    private static POMErrorFixBase instantiateRule(FileObject fileObject) {
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            InstanceCookie ic = (InstanceCookie)dobj.getLookup().lookup(InstanceCookie.class);
            Object instance = ic.instanceCreate();
            if (instance instanceof POMErrorFixBase) {
                return (POMErrorFixBase)instance;
            }
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, null, e);
        }
        return null;
    }
}

