/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class RubyEmbeddingProvider
extends EmbeddingProvider {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    private static final Logger LOG = Logger.getLogger(RubyEmbeddingProvider.class.getName());

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if ("text/x-yaml".equals(snapshot.getMimeType())) {
            List<Embedding> embeddings = this.translate(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + "text/x-yaml" + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Embedding> translate(Snapshot snapshot) {
        BaseDocument d = (BaseDocument)snapshot.getSource().getDocument(false);
        if (d == null) {
            return Collections.emptyList();
        }
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        try {
            d.readLock();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)d);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(YamlTokenId.language());
            if (tokenSequence != null) {
                this.translate(snapshot, (TokenHierarchy<Document>)tokenHierarchy, (TokenSequence<? extends YamlTokenId>)tokenSequence, embeddings);
            }
        }
        finally {
            d.readUnlock();
        }
        return embeddings;
    }

    private void translate(Snapshot snapshot, TokenHierarchy<Document> tokenHierarchy, TokenSequence<? extends YamlTokenId> tokenSequence, List<Embedding> embeddings) {
        embeddings.add(snapshot.create((CharSequence)"_buf='';", RUBY_MIME_TYPE));
        boolean skipNewline = false;
        while (tokenSequence.moveNext()) {
            String text;
            int sourceStart;
            Token token = tokenSequence.token();
            if (token.id() == YamlTokenId.TEXT || token.id() == YamlTokenId.COMMENT) {
                int i;
                sourceStart = token.offset(tokenHierarchy);
                text = token.text().toString();
                boolean found = false;
                for (i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        ++i;
                        found = true;
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                if (found && tokenSequence.index() < tokenSequence.tokenCount() - 1) {
                    embeddings.add(snapshot.create(sourceStart, i, RUBY_MIME_TYPE));
                    text = text.substring(i);
                } else {
                    embeddings.add(snapshot.create((CharSequence)";", RUBY_MIME_TYPE));
                }
                embeddings.add(snapshot.create((CharSequence)"_buf << '", RUBY_MIME_TYPE));
                if (skipNewline && text.startsWith("\n")) {
                    text = text.substring(1);
                }
                text = text.replace("'", "\\'");
                embeddings.add(snapshot.create((CharSequence)text, RUBY_MIME_TYPE));
                embeddings.add(snapshot.create((CharSequence)"';\n", RUBY_MIME_TYPE));
                skipNewline = false;
                continue;
            }
            if (token.id() == YamlTokenId.RUBY) {
                sourceStart = token.offset(tokenHierarchy);
                text = token.text().toString();
                skipNewline = false;
                if (text.endsWith("-")) {
                    text = text.substring(0, text.length() - 1);
                    skipNewline = true;
                }
                embeddings.add(snapshot.create(sourceStart, text.length(), RUBY_MIME_TYPE));
                skipNewline = false;
                continue;
            }
            if (token.id() != YamlTokenId.RUBY_EXPR) continue;
            embeddings.add(snapshot.create((CharSequence)"_buf << (", RUBY_MIME_TYPE));
            sourceStart = token.offset(tokenHierarchy);
            text = token.text().toString();
            skipNewline = false;
            if (text.endsWith("-")) {
                text = text.substring(0, text.length() - 1);
                skipNewline = true;
            }
            embeddings.add(snapshot.create(sourceStart, text.length(), RUBY_MIME_TYPE));
            embeddings.add(snapshot.create((CharSequence)").to_s;", RUBY_MIME_TYPE));
        }
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (!"text/x-yaml".equals(snapshot.getMimeType())) {
                return Collections.emptyList();
            }
            return Collections.singleton(new RubyEmbeddingProvider());
        }
    }
}

