/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.ClassMap;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.api.JUnitVersion;

final class JUnit4TestGenerator
extends AbstractTestGenerator {
    static final String ANN_BEFORE_CLASS = "org.junit.BeforeClass";
    static final String ANN_AFTER_CLASS = "org.junit.AfterClass";
    static final String ANN_BEFORE = "org.junit.Before";
    static final String ANN_AFTER = "org.junit.After";
    static final String ANN_TEST = "org.junit.Test";
    private static final String ANN_RUN_WITH = "org.junit.runner.RunWith";
    private static final String ANN_SUITE = "org.junit.runners.Suite";
    private static final String ANN_SUITE_MEMBERS = "SuiteClasses";
    private static final String BEFORE_CLASS_METHOD_NAME = "setUpClass";
    private static final String AFTER_CLASS_METHOD_NAME = "tearDownClass";
    private static final String BEFORE_METHOD_NAME = "setUp";
    private static final String AFTER_METHOD_NAME = "tearDown";

    JUnit4TestGenerator(TestGeneratorSetup setup) {
        super(setup, JUnitVersion.JUNIT4);
    }

    JUnit4TestGenerator(TestGeneratorSetup setup, List<ElementHandle<TypeElement>> srcTopClassHandles, List<String> suiteMembers, boolean isNewTestClass) {
        super(setup, srcTopClassHandles, suiteMembers, isNewTestClass, JUnitVersion.JUNIT4);
    }

    @Override
    protected ClassTree composeNewTestClass(WorkingCopy workingCopy, String name, List<? extends Tree> members) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ModifiersTree modifiers = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        return maker.Class(modifiers, (CharSequence)name, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList(), members);
    }

    @Override
    protected List<? extends Tree> generateInitMembers(WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return Collections.emptyList();
        }
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(4);
        if (this.setup.isGenerateBeforeClass()) {
            result.add(this.generateInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateAfterClass()) {
            result.add(this.generateInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateBefore()) {
            result.add(this.generateInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, workingCopy));
        }
        if (this.setup.isGenerateAfter()) {
            result.add(this.generateInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, workingCopy));
        }
        return result;
    }

    @Override
    protected ClassTree generateMissingInitMembers(ClassTree tstClass, TreePath tstClassTreePath, WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return tstClass;
        }
        ClassMap classMap = ClassMap.forClass(tstClass, tstClassTreePath, workingCopy.getTrees());
        if (!(this.setup.isGenerateBefore() && !classMap.containsBefore() || this.setup.isGenerateAfter() && !classMap.containsAfter() || this.setup.isGenerateBeforeClass() && !classMap.containsBeforeClass() || this.setup.isGenerateAfterClass() && !classMap.containsAfterClass())) {
            return tstClass;
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        List<? extends Tree> tstMembersOrig = tstClass.getMembers();
        ArrayList<Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 4);
        tstMembers.addAll(tstMembersOrig);
        this.generateMissingInitMembers(tstMembers, classMap, workingCopy);
        ClassTree newClass = maker.Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstClass.getPermitsClause(), tstMembers);
        return newClass;
    }

    @Override
    protected boolean generateMissingInitMembers(List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        int afterClassIndex;
        int beforeClassIndex;
        int afterIndex;
        int beforeIndex;
        int targetIndex;
        boolean modified = false;
        if (this.setup.isGenerateBeforeClass() && !clsMap.containsBeforeClass()) {
            if (clsMap.containsAfterClass()) {
                targetIndex = clsMap.getAfterClassIndex();
            } else {
                beforeIndex = clsMap.getBeforeIndex();
                afterIndex = clsMap.getAfterIndex();
                targetIndex = beforeIndex != -1 && afterIndex != -1 ? Math.min(beforeIndex, afterIndex) : Math.max(beforeIndex, afterIndex);
            }
            this.addInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateAfterClass() && !clsMap.containsAfterClass()) {
            if (clsMap.containsBeforeClass()) {
                targetIndex = clsMap.getBeforeClassIndex() + 1;
            } else {
                beforeIndex = clsMap.getBeforeIndex();
                afterIndex = clsMap.getAfterIndex();
                targetIndex = beforeIndex != -1 && afterIndex != -1 ? Math.min(beforeIndex, afterIndex) : Math.max(beforeIndex, afterIndex);
            }
            this.addInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateBefore() && !clsMap.containsBefore()) {
            if (clsMap.containsAfter()) {
                targetIndex = clsMap.getAfterIndex();
            } else {
                beforeClassIndex = clsMap.getBeforeClassIndex();
                targetIndex = Math.max(beforeClassIndex, afterClassIndex = clsMap.getAfterClassIndex());
                if (targetIndex != -1) {
                    ++targetIndex;
                }
            }
            this.addInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateAfter() && !clsMap.containsAfter()) {
            if (clsMap.containsBefore()) {
                targetIndex = clsMap.getBeforeIndex() + 1;
            } else {
                beforeClassIndex = clsMap.getBeforeClassIndex();
                targetIndex = Math.max(beforeClassIndex, afterClassIndex = clsMap.getAfterClassIndex());
                if (targetIndex != -1) {
                    ++targetIndex;
                }
            }
            this.addInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        return modified;
    }

    private void addInitMethod(String methodName, String annotationClassName, boolean isStatic, int targetIndex, List<Tree> clsMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        MethodTree initMethod = this.generateInitMethod(methodName, annotationClassName, isStatic, workingCopy);
        if (targetIndex == -1) {
            targetIndex = this.getPlaceForFirstInitMethod(clsMap);
        }
        if (targetIndex != -1) {
            clsMembers.add(targetIndex, initMethod);
        } else {
            clsMembers.add(initMethod);
        }
        clsMap.addNoArgMethod(methodName, annotationClassName, targetIndex);
    }

    private MethodTree generateInitMethod(String methodName, String annotationClassName, boolean isStatic, WorkingCopy workingCopy) {
        Set<Modifier> methodModifiers = isStatic ? JUnit4TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC) : Collections.singleton(Modifier.PUBLIC);
        ModifiersTree modifiers = this.createModifiersTree(annotationClassName, methodModifiers, workingCopy);
        TreeMaker maker = workingCopy.getTreeMaker();
        BlockTree methodBody = maker.Block(Collections.emptyList(), false);
        MethodTree method = maker.Method(modifiers, (CharSequence)methodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(maker.Identifier((CharSequence)"Exception")), methodBody, null);
        return method;
    }

    @Override
    protected void generateMissingPostInitMethods(TreePath tstClassTreePath, List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
    }

    @Override
    protected MethodTree composeNewTestMethod(String testMethodName, BlockTree testMethodBody, List<ExpressionTree> throwsList, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        return maker.Method(this.createModifiersTree(ANN_TEST, JUnit4TestGenerator.createModifierSet(Modifier.PUBLIC), workingCopy), (CharSequence)testMethodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), throwsList, testMethodBody, null);
    }

    @Override
    protected ClassTree finishSuiteClass(ClassTree tstClass, TreePath tstClassTreePath, List<Tree> tstMembers, List<String> suiteMembers, boolean membersChanged, ClassMap classMap, WorkingCopy workingCopy) {
        ModifiersTree currModifiers = tstClass.getModifiers();
        ModifiersTree modifiers = this.fixSuiteClassModifiers(tstClass, tstClassTreePath, currModifiers, suiteMembers, workingCopy);
        if (!membersChanged) {
            if (modifiers != currModifiers) {
                workingCopy.rewrite((Tree)currModifiers, (Tree)modifiers);
            }
            return tstClass;
        }
        return workingCopy.getTreeMaker().Class(modifiers, (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstClass.getPermitsClause(), tstMembers);
    }

    private ModifiersTree fixSuiteClassModifiers(ClassTree tstClass, TreePath tstClassTreePath, ModifiersTree modifiers, List<String> suiteMembers, WorkingCopy workingCopy) {
        List<AnnotationTree> annotations;
        boolean flagsModified = false;
        Set<Modifier> currFlags = modifiers.getFlags();
        Set<Modifier> flags = EnumSet.noneOf(Modifier.class);
        if (!currFlags.isEmpty()) {
            flags.addAll(currFlags);
        }
        flagsModified |= flags.remove((Object)Modifier.PRIVATE);
        flagsModified |= flags.remove((Object)Modifier.PROTECTED);
        if (!(flagsModified |= flags.add(Modifier.PUBLIC))) {
            flags = currFlags;
        }
        boolean annotationListModified = false;
        List<? extends AnnotationTree> currAnnotations = modifiers.getAnnotations();
        if (currAnnotations.isEmpty()) {
            ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>(2);
            newAnnotations.add(this.createRunWithSuiteAnnotation(workingCopy));
            newAnnotations.add(this.createSuiteAnnotation(suiteMembers, workingCopy));
            annotations = newAnnotations;
            annotationListModified = true;
        } else {
            Trees trees = workingCopy.getTrees();
            Element classElement = trees.getElement(tstClassTreePath);
            List<? extends AnnotationMirror> annMirrors = classElement.getAnnotationMirrors();
            assert (annMirrors.size() == currAnnotations.size());
            int index = -1;
            int runWithIndex = -1;
            int suiteClassesIndex = -1;
            for (AnnotationMirror annotationMirror : annMirrors) {
                ++index;
                Element annElement = annotationMirror.getAnnotationType().asElement();
                assert (annElement instanceof TypeElement);
                TypeElement annTypeElem = (TypeElement)annElement;
                Name annFullName = annTypeElem.getQualifiedName();
                if (runWithIndex == -1 && annFullName.contentEquals(ANN_RUN_WITH)) {
                    runWithIndex = index;
                    continue;
                }
                if (suiteClassesIndex != -1 || !annFullName.contentEquals("org.junit.runners.Suite.SuiteClasses")) continue;
                suiteClassesIndex = index;
            }
            AnnotationTree runWithSuiteAnn = runWithIndex == -1 || !this.checkRunWithSuiteAnnotation(annMirrors.get(runWithIndex), workingCopy) ? this.createRunWithSuiteAnnotation(workingCopy) : currAnnotations.get(runWithIndex);
            if (suiteClassesIndex == -1 || !this.checkSuiteMembersAnnotation(annMirrors.get(suiteClassesIndex), suiteMembers, workingCopy)) {
                AnnotationTree annotationTree = this.createSuiteAnnotation(suiteMembers, workingCopy);
            } else {
                AnnotationTree annotationTree = currAnnotations.get(suiteClassesIndex);
            }
            if (runWithIndex != -1 && suiteClassesIndex != -1) {
                if (runWithSuiteAnn != currAnnotations.get(runWithIndex)) {
                    workingCopy.rewrite((Tree)currAnnotations.get(runWithIndex), (Tree)runWithSuiteAnn);
                }
                if (var19_23 != currAnnotations.get(suiteClassesIndex)) {
                    workingCopy.rewrite((Tree)currAnnotations.get(suiteClassesIndex), (Tree)var19_23);
                }
                annotations = currAnnotations;
            } else {
                ArrayList<Object> newAnnotations = new ArrayList<Object>(currAnnotations.size() + 2);
                if (runWithIndex == -1 && suiteClassesIndex == -1) {
                    newAnnotations.add(runWithSuiteAnn);
                    newAnnotations.add(var19_23);
                    if (!currAnnotations.isEmpty()) {
                        newAnnotations.addAll(currAnnotations);
                    }
                } else {
                    newAnnotations.addAll(currAnnotations);
                    if (runWithIndex == -1) {
                        assert (suiteClassesIndex != 1);
                        newAnnotations.add(suiteClassesIndex, runWithSuiteAnn);
                    } else {
                        assert (runWithIndex != -1);
                        newAnnotations.add(runWithIndex + 1, var19_23);
                    }
                }
                annotations = newAnnotations;
                annotationListModified = true;
            }
        }
        if (!flagsModified && !annotationListModified) {
            return modifiers;
        }
        return workingCopy.getTreeMaker().Modifiers(flags, annotations);
    }

    private boolean checkRunWithSuiteAnnotation(AnnotationMirror annMirror, WorkingCopy workingCopy) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annParams = annMirror.getElementValues();
        if (annParams.size() != 1) {
            return false;
        }
        AnnotationValue annValue = annParams.values().iterator().next();
        Name annValueClsName = this.getAnnotationValueClassName(annValue, workingCopy.getTypes());
        return annValueClsName != null ? annValueClsName.contentEquals(ANN_SUITE) : false;
    }

    private boolean checkSuiteMembersAnnotation(AnnotationMirror annMirror, List<String> suiteMembers, WorkingCopy workingCopy) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annParams = annMirror.getElementValues();
        if (annParams.size() != 1) {
            return false;
        }
        AnnotationValue annValue = annParams.values().iterator().next();
        Object value = annValue.getValue();
        if (value instanceof List) {
            List items = (List)value;
            if (items.size() != suiteMembers.size()) {
                return false;
            }
            Types types = workingCopy.getTypes();
            Iterator<String> suiteMembersIt = suiteMembers.iterator();
            for (AnnotationValue item : items) {
                Name suiteMemberName = this.getAnnotationValueClassName(item, types);
                if (suiteMemberName == null) {
                    return false;
                }
                if (suiteMemberName.contentEquals(suiteMembersIt.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Name getAnnotationValueClassName(AnnotationValue annValue, Types types) {
        TypeMirror typeMirror;
        Element typeElement;
        Object value = annValue.getValue();
        if (value instanceof TypeMirror && (typeElement = types.asElement(typeMirror = (TypeMirror)value)).getKind() == ElementKind.CLASS) {
            return ((TypeElement)typeElement).getQualifiedName();
        }
        return null;
    }

    private AnnotationTree createRunWithSuiteAnnotation(WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        return maker.Annotation((Tree)this.getClassIdentifierTree(ANN_RUN_WITH, workingCopy), Collections.singletonList(maker.MemberSelect(this.getClassIdentifierTree(ANN_SUITE, workingCopy), (CharSequence)"class")));
    }

    private AnnotationTree createSuiteAnnotation(List<String> suiteMembers, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ArrayList<MemberSelectTree> suiteMemberExpressions = new ArrayList<MemberSelectTree>(suiteMembers.size());
        for (String suiteMember : suiteMembers) {
            suiteMemberExpressions.add(maker.MemberSelect(this.getClassIdentifierTree(suiteMember, workingCopy), (CharSequence)"class"));
        }
        return maker.Annotation((Tree)maker.MemberSelect(this.getClassIdentifierTree(ANN_SUITE, workingCopy), (CharSequence)ANN_SUITE_MEMBERS), Collections.singletonList(maker.NewArray(null, Collections.emptyList(), suiteMemberExpressions)));
    }
}

