/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.gsf.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class TestClassInfoTask
implements Task<CompilationController> {
    private final int caretPosition;
    private SingleMethod singleMethod;
    private static final String JUNIT4_ANNOTATION = "org.junit.Test";
    private static final String JUNIT5_NESTED_ANNOTATION = "org.junit.jupiter.api.Nested";
    private static final String JUNIT5_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    private static final String TESTCASE = "junit.framework.TestCase";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void run(CompilationController controller) throws Exception {
        controller.toPhase(JavaSource.Phase.RESOLVED);
        List<TestMethodController.TestMethod> methods = TestClassInfoTask.computeTestMethods((CompilationInfo)controller, new AtomicBoolean(), this.caretPosition);
        this.singleMethod = !methods.isEmpty() ? methods.get(0).method() : null;
    }

    public static List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info, AtomicBoolean cancel, int caretPosIfAny) {
        FileObject fileObject = info.getFileObject();
        if (!TestClassInfoTask.isTestSource(fileObject)) {
            return Collections.emptyList();
        }
        return TestClassInfoTask.doComputeTestMethods(info, cancel, caretPosIfAny);
    }

    private static List<TestMethodController.TestMethod> doComputeTestMethods(CompilationInfo info, AtomicBoolean cancel, int caretPosIfAny) {
        TreePath tp;
        ArrayList<TestMethodController.TestMethod> result = new ArrayList<TestMethodController.TestMethod>();
        if (caretPosIfAny == -1) {
            Optional<Tree> anyClass = info.getCompilationUnit().getTypeDecls().stream().filter(t -> t.getKind() == Tree.Kind.CLASS).findAny();
            if (!anyClass.isPresent()) {
                return Collections.emptyList();
            }
            ClassTree clazz = (ClassTree)anyClass.get();
            TreePath pathToClass = new TreePath(new TreePath(info.getCompilationUnit()), clazz);
            List<TreePath> methods = clazz.getMembers().stream().filter(m -> m.getKind() == Tree.Kind.METHOD).map(m -> new TreePath(pathToClass, (Tree)m)).collect(Collectors.toList());
            TestClassInfoTask.collect(info, pathToClass, methods, true, cancel, result);
            return result;
        }
        for (tp = info.getTreeUtilities().pathFor(caretPosIfAny); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
        }
        if (tp != null) {
            TestClassInfoTask.collect(info, tp.getParentPath(), Collections.singletonList(tp), false, cancel, result);
            return result;
        }
        return Collections.emptyList();
    }

    SingleMethod getSingleMethod() {
        return this.singleMethod;
    }

    private static void collect(CompilationInfo info, TreePath clazz, List<TreePath> methods, boolean searchNested, AtomicBoolean cancel, List<TestMethodController.TestMethod> result) {
        Trees trees = info.getTrees();
        Elements elements = info.getElements();
        TreeUtilities treeUtilities = info.getTreeUtilities();
        int clazzPreferred = treeUtilities.findNameSpan((ClassTree)clazz.getLeaf())[0];
        TypeElement typeElement = (TypeElement)trees.getElement(clazz);
        TypeElement testcase = elements.getTypeElement(TESTCASE);
        boolean junit3 = testcase != null && typeElement != null ? info.getTypes().isSubtype(typeElement.asType(), testcase.asType()) : false;
        for (TreePath tp : methods) {
            if (cancel.get()) {
                return;
            }
            Element element = trees.getElement(tp);
            if (element == null) continue;
            String mn = element.getSimpleName().toString();
            boolean testMethod = false;
            if (junit3) {
                testMethod = mn.startsWith("test");
            } else {
                List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
                if (TestClassInfoTask.isJunit4Test(allAnnotationMirrors) || TestClassInfoTask.isJunit5Testable(allAnnotationMirrors)) {
                    testMethod = true;
                }
            }
            if (!testMethod) continue;
            SourcePositions sp = trees.getSourcePositions();
            int start = (int)sp.getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
            int preferred = treeUtilities.findNameSpan((MethodTree)tp.getLeaf())[0];
            int end = (int)sp.getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
            Document doc = info.getSnapshot().getSource().getDocument(false);
            try {
                result.add(new TestMethodController.TestMethod(elements.getBinaryName(typeElement).toString(), doc != null ? doc.createPosition(clazzPreferred) : new SimplePosition(clazzPreferred), new SingleMethod(info.getFileObject(), mn), doc != null ? doc.createPosition(start) : new SimplePosition(start), doc != null ? doc.createPosition(preferred) : new SimplePosition(preferred), doc != null ? doc.createPosition(end) : new SimplePosition(end)));
            }
            catch (BadLocationException badLocationException) {}
        }
        if (searchNested && !cancel.get()) {
            ((ClassTree)clazz.getLeaf()).getMembers().stream().filter(m -> m.getKind() == Tree.Kind.CLASS).map(n -> new TreePath(clazz, (Tree)n)).forEach(nested -> {
                List<? extends AnnotationMirror> allAnnotationMirrors;
                Element nestedElement;
                if (!cancel.get() && (nestedElement = trees.getElement((TreePath)nested)) != null && !junit3 && TestClassInfoTask.isJunit5Nested(allAnnotationMirrors = elements.getAllAnnotationMirrors(nestedElement))) {
                    List<TreePath> nestedMethods = ((ClassTree)nested.getLeaf()).getMembers().stream().filter(m -> m.getKind() == Tree.Kind.METHOD).map(m -> new TreePath((TreePath)nested, (Tree)m)).collect(Collectors.toList());
                    TestClassInfoTask.collect(info, nested, nestedMethods, true, cancel, result);
                }
            });
        }
    }

    private static boolean isTestSource(FileObject fo) {
        FileObject root;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp != null && (root = cp.findOwnerRoot(fo)) != null) {
            return UnitTestForSourceQuery.findSources((FileObject)root).length > 0;
        }
        return false;
    }

    private static boolean isJunit4Test(List<? extends AnnotationMirror> allAnnotationMirrors) {
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().contentEquals(JUNIT4_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJunit5Nested(List<? extends AnnotationMirror> allAnnotationMirrors) {
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().contentEquals(JUNIT5_NESTED_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJunit5Testable(List<? extends AnnotationMirror> allAnnotationMirrors) {
        ArrayDeque<? extends AnnotationMirror> pendingMirrorsToCheck = new ArrayDeque<AnnotationMirror>(allAnnotationMirrors);
        HashSet<? extends AnnotationMirror> alreadyAddedMirrorsToCheck = new HashSet<AnnotationMirror>(allAnnotationMirrors);
        while (pendingMirrorsToCheck.peek() != null) {
            AnnotationMirror annotationMirror = (AnnotationMirror)pendingMirrorsToCheck.poll();
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationElement.getQualifiedName().contentEquals(JUNIT5_ANNOTATION)) {
                return true;
            }
            List<? extends AnnotationMirror> parentAnnotationMirrors = annotationElement.getAnnotationMirrors();
            Set newlySeenParentAnnotationMirrors = parentAnnotationMirrors.stream().filter(parentAnnotationMirror -> !alreadyAddedMirrorsToCheck.contains(parentAnnotationMirror)).collect(Collectors.toSet());
            pendingMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
            alreadyAddedMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
        }
        return false;
    }

    private static class SimplePosition
    implements Position {
        private final int offset;

        private SimplePosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    public static final class GenericComputeTestMethodsImpl
    implements ComputeTestMethods {
        public List<TestMethodController.TestMethod> computeTestMethods(Parser.Result parserResult, AtomicBoolean cancel) {
            try {
                CompilationController cc = CompilationController.get((Parser.Result)parserResult);
                if (TestClassInfoTask.isTestSource(cc.getFileObject()) && cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                    return TestClassInfoTask.doComputeTestMethods((CompilationInfo)cc, cancel, -1);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return Collections.emptyList();
        }
    }

    public static final class ComputeTestMethodsImpl
    implements ComputeTestMethods.Factory {
        public org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods create() {
            return new TaskImpl();
        }

        private static class TaskImpl
        implements org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods {
            private final AtomicBoolean cancel = new AtomicBoolean();

            private TaskImpl() {
            }

            public void cancel() {
                this.cancel.set(true);
            }

            public List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info) {
                return TestClassInfoTask.computeTestMethods(info, this.cancel, -1);
            }
        }
    }
}

