/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitVersion;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.ui.JUnitTestCreatorProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

abstract class AbstractJUnitTestCreatorProvider
extends TestCreatorProvider {
    AbstractJUnitTestCreatorProvider() {
    }

    abstract JUnitVersion useVersion();

    public boolean enable(FileObject[] activatedFOs) {
        if (activatedFOs == null || activatedFOs.length == 0) {
            return false;
        }
        if (activatedFOs.length == 1) {
            Project project;
            FileObject fileObj = activatedFOs[0];
            if (fileObj != null && fileObj.isValid() && (fileObj.isFolder() || JUnitTestUtil.isJavaFile((FileObject)fileObj)) && (project = FileOwnerQuery.getOwner((FileObject)fileObj)) != null && AbstractJUnitTestCreatorProvider.getSourceGroup((FileObject)fileObj, (Project)project) != null) {
                JUnitPlugin plugin = JUnitTestUtil.getPluginForProject((Project)project, (JUnitVersion)this.useVersion());
                return JUnitTestUtil.canCreateTests((JUnitPlugin)plugin, (FileObject[])new FileObject[]{fileObj});
            }
            return false;
        }
        ArrayList<FileObject> fileObjs = new ArrayList<FileObject>(activatedFOs.length);
        Project theProject = null;
        boolean result = false;
        for (FileObject fileObj : activatedFOs) {
            if (fileObj == null || !fileObj.isValid() && (fileObj.isFolder() || JUnitTestUtil.isJavaFile((FileObject)fileObj))) continue;
            fileObjs.add(fileObj);
            Project prj = FileOwnerQuery.getOwner((FileObject)fileObj);
            if (prj == null) continue;
            if (theProject == null) {
                theProject = prj;
            }
            if (prj != theProject) {
                return false;
            }
            if (AbstractJUnitTestCreatorProvider.getSourceGroup((FileObject)fileObj, (Project)prj) == null) continue;
            result = true;
        }
        if (theProject != null) {
            JUnitPlugin plugin = JUnitTestUtil.getPluginForProject(theProject);
            result &= JUnitTestUtil.canCreateTests((JUnitPlugin)plugin, (FileObject[])fileObjs.toArray(new FileObject[fileObjs.size()]));
        }
        return result;
    }

    public void createTests(TestCreatorProvider.Context context) {
        String problem = AbstractJUnitTestCreatorProvider.checkNodesValidity(context.getActivatedFOs());
        if (problem != null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)problem, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        final FileObject[] filesToTest = context.getActivatedFOs();
        if (filesToTest == null) {
            return;
        }
        final JUnitPlugin plugin = JUnitTestUtil.getPluginForProject((Project)FileOwnerQuery.getOwner((FileObject)filesToTest[0]), (JUnitVersion)this.useVersion());
        if (!JUnitTestUtil.createTestActionCalled((JUnitPlugin)plugin, (FileObject[])filesToTest)) {
            return;
        }
        boolean singleClass = context.isSingleClass();
        final Map params = JUnitTestUtil.getSettingsMap((!singleClass ? 1 : 0) != 0);
        if (singleClass) {
            params.put(CommonPlugin.CreateTestParam.CLASS_NAME, context.getTestClassName());
        }
        final FileObject targetFolder = context.getTargetFolder();
        if (context.isIntegrationTests()) {
            params.put(CommonPlugin.CreateTestParam.INC_GENERATE_INTEGRATION_TEST, Boolean.TRUE);
        } else {
            params.put(CommonPlugin.CreateTestParam.INC_GENERATE_INTEGRATION_TEST, Boolean.FALSE);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                FileObject[] testFileObjects = JUnitTestUtil.createTests((JUnitPlugin)plugin, (FileObject[])filesToTest, (FileObject)targetFolder, (Map)params);
                if (testFileObjects.length == 1) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)testFileObjects[0]);
                        final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                        if (ec != null) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ec.open();
                                }
                            });
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private static String checkNodesValidity(FileObject[] files) {
        Project project = AbstractJUnitTestCreatorProvider.getProject(files);
        if (project == null) {
            return NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_multiproject_selection");
        }
        if (!AbstractJUnitTestCreatorProvider.checkPackages(files)) {
            return NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_invalid_packages");
        }
        return null;
    }

    private static FileObject[] getFileObjectsFromNodes(Node[] nodes) {
        FileObject[] fileObjects = new FileObject[nodes.length];
        ArrayList<FileObject> fileObjectsList = null;
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo;
            Node node = nodes[i];
            if (!AbstractJUnitTestCreatorProvider.hasParentAmongNodes(nodes, i) && (fo = AbstractJUnitTestCreatorProvider.getTestFileObject(node)) != null) {
                if (fileObjects != null) {
                    fileObjects[i] = fo;
                    continue;
                }
                if (fileObjectsList == null) {
                    fileObjectsList = new ArrayList<FileObject>(nodes.length - i);
                }
                fileObjectsList.add(fo);
                continue;
            }
            fileObjects = null;
        }
        if (fileObjects == null && fileObjectsList != null) {
            fileObjects = fileObjectsList.toArray(new FileObject[fileObjectsList.size()]);
            fileObjectsList = null;
        }
        return fileObjects;
    }

    private static boolean checkPackages(FileObject[] files) {
        if (files.length == 0) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)files[0]);
        for (int i = 0; i < files.length; ++i) {
            String packageName = AbstractJUnitTestCreatorProvider.getPackage(project, files[i]);
            if (packageName != null && JUnitTestUtil.isValidPackageName((String)packageName)) continue;
            return false;
        }
        return true;
    }

    private static String getPackage(Project project, FileObject file) {
        SourceGroup srcGrp = JUnitTestUtil.findSourceGroupOwner((Project)project, (FileObject)file);
        if (srcGrp != null) {
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{srcGrp.getRootFolder()});
            return cp.getResourceName(file, '.', false);
        }
        return null;
    }

    private static FileObject[] getFiles(Node[] nodes) {
        FileObject[] ret = new FileObject[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ret[i] = UICommonUtils.getFileObjectFromNode((Node)nodes[i]);
        }
        return ret;
    }

    private static Project getProject(FileObject[] files) {
        Project project = null;
        for (int i = 0; i < files.length; ++i) {
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)files[i]);
            if (project == null) {
                project = nodeProject;
                continue;
            }
            if (project == nodeProject) continue;
            return null;
        }
        return project;
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fo = UICommonUtils.getFileObjectFromNode((Node)node);
        if (fo == null) {
            JUnitTestUtil.notifyUser((String)NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_file_from_node_failed"));
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            JUnitTestUtil.notifyUser((String)NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_no_project", (Object)fo));
            return null;
        }
        return fo;
    }

    private static boolean hasParentAmongNodes(Node[] nodes, int idx) {
        for (Node node = nodes[idx].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (i == idx || node != nodes[i]) continue;
                return true;
            }
        }
        return false;
    }
}

