/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;

public final class TestClassInfoTask
implements Task<CompilationController> {
    private final int caretPosition;
    private SingleMethod singleMethod;
    private static final String JUNIT4_ANNOTATION = "org.junit.Test";
    private static final String JUNIT5_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    private static final String TESTCASE = "junit.framework.TestCase";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void run(CompilationController controller) throws Exception {
        controller.toPhase(JavaSource.Phase.RESOLVED);
        List<TestMethodController.TestMethod> methods = TestClassInfoTask.computeTestMethods((CompilationInfo)controller, new AtomicBoolean(), this.caretPosition);
        this.singleMethod = !methods.isEmpty() ? methods.get(0).method() : null;
    }

    public static List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info, AtomicBoolean cancel, int caretPosIfAny) {
        List<TreePath> methods;
        ClassTree clazz;
        FileObject fileObject = info.getFileObject();
        if (caretPosIfAny == -1) {
            Optional<Tree> anyClass = info.getCompilationUnit().getTypeDecls().stream().filter(t -> t.getKind() == Tree.Kind.CLASS).findAny();
            if (!anyClass.isPresent()) {
                return Collections.emptyList();
            }
            clazz = (ClassTree)anyClass.get();
            TreePath pathToClass = new TreePath(new TreePath(info.getCompilationUnit()), clazz);
            methods = clazz.getMembers().stream().filter(m -> m.getKind() == Tree.Kind.METHOD).map(m -> new TreePath(pathToClass, (Tree)m)).collect(Collectors.toList());
        } else {
            TreePath tp;
            for (tp = info.getTreeUtilities().pathFor(caretPosIfAny); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
            }
            if (tp != null) {
                clazz = (ClassTree)tp.getParentPath().getLeaf();
                methods = Collections.singletonList(tp);
            } else {
                return Collections.emptyList();
            }
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(new TreePath(new TreePath(info.getCompilationUnit()), clazz));
        Elements elements = info.getElements();
        TypeElement testcase = elements.getTypeElement(TESTCASE);
        boolean junit3 = testcase != null && typeElement != null ? info.getTypes().isSubtype(typeElement.asType(), testcase.asType()) : false;
        ArrayList<TestMethodController.TestMethod> result = new ArrayList<TestMethodController.TestMethod>();
        for (TreePath tp : methods) {
            if (cancel.get()) {
                return null;
            }
            Element element = info.getTrees().getElement(tp);
            if (element == null) continue;
            String mn = element.getSimpleName().toString();
            boolean testMethod = false;
            if (junit3) {
                testMethod = mn.startsWith("test");
            } else {
                List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
                if (TestClassInfoTask.isJunit4Test(allAnnotationMirrors) || TestClassInfoTask.isJunit5Testable(allAnnotationMirrors)) {
                    testMethod = true;
                }
            }
            if (!testMethod) continue;
            SourcePositions sp = info.getTrees().getSourcePositions();
            int start = (int)sp.getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
            int end = (int)sp.getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
            Document doc = info.getSnapshot().getSource().getDocument(false);
            try {
                result.add(new TestMethodController.TestMethod(new SingleMethod(fileObject, mn), doc != null ? doc.createPosition(start) : null, doc != null ? doc.createPosition(end) : null));
            }
            catch (BadLocationException badLocationException) {}
        }
        return result;
    }

    SingleMethod getSingleMethod() {
        return this.singleMethod;
    }

    private static boolean isJunit4Test(List<? extends AnnotationMirror> allAnnotationMirrors) {
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().contentEquals(JUNIT4_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJunit5Testable(List<? extends AnnotationMirror> allAnnotationMirrors) {
        ArrayDeque<? extends AnnotationMirror> pendingMirrorsToCheck = new ArrayDeque<AnnotationMirror>(allAnnotationMirrors);
        HashSet<? extends AnnotationMirror> alreadyAddedMirrorsToCheck = new HashSet<AnnotationMirror>(allAnnotationMirrors);
        while (pendingMirrorsToCheck.peek() != null) {
            AnnotationMirror annotationMirror = (AnnotationMirror)pendingMirrorsToCheck.poll();
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationElement.getQualifiedName().contentEquals(JUNIT5_ANNOTATION)) {
                return true;
            }
            List<? extends AnnotationMirror> parentAnnotationMirrors = annotationElement.getAnnotationMirrors();
            Set newlySeenParentAnnotationMirrors = parentAnnotationMirrors.stream().filter(parentAnnotationMirror -> !alreadyAddedMirrorsToCheck.contains(parentAnnotationMirror)).collect(Collectors.toSet());
            pendingMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
            alreadyAddedMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
        }
        return false;
    }

    public static final class ComputeTestMethodsImpl
    implements ComputeTestMethods.Factory {
        public ComputeTestMethods create() {
            return new TaskImpl();
        }

        private static class TaskImpl
        implements ComputeTestMethods {
            private final AtomicBoolean cancel = new AtomicBoolean();

            private TaskImpl() {
            }

            public void cancel() {
                this.cancel.set(true);
            }

            public List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info) {
                return TestClassInfoTask.computeTestMethods(info, this.cancel, -1);
            }
        }
    }
}

