/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import com.oracle.js.parser.Token;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.PropertyNode;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.model.AnonymousObject;
import org.netbeans.modules.javascript2.model.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.model.EmbeddingHelper;
import org.netbeans.modules.javascript2.model.JsArrayImpl;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.ModelBuilder;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.spi.ParserResult;

class ModelElementFactory {
    ModelElementFactory() {
    }

    @CheckForNull
    static JsFunctionImpl create(ParserResult parserResult, FunctionNode functionNode, List<Identifier> fqName, ModelBuilder modelBuilder, boolean isAnnonymous, JsObject parent) {
        JsDocumentationHolder docHolder;
        JsFunctionImpl result;
        if (EmbeddingHelper.containsGeneratedIdentifier(fqName.get(fqName.size() - 1).getName())) {
            return null;
        }
        JsObjectImpl inObject = modelBuilder.getCurrentObject();
        JsObjectImpl globalObject = modelBuilder.getGlobal();
        JsObject parentObject = parent;
        if (parent == null) {
            DeclarationScopeImpl decScope;
            parentObject = isAnnonymous ? ((decScope = modelBuilder.getCurrentDeclarationScope()) == null ? globalObject : decScope) : inObject;
            while (parentObject.getParent() != null && parentObject.getModifiers().contains(Modifier.PROTECTED)) {
                parentObject = parentObject.getParent();
            }
        }
        int start = Token.descPosition((long)functionNode.getFirstToken());
        int end = Token.descPosition((long)functionNode.getLastToken()) + Token.descLength((long)functionNode.getLastToken());
        if (end <= start) {
            end = start + 1;
            assert (false) : "The end offset of a function is before the start offset: [" + start + ", " + end + "] in file: " + parserResult.getSnapshot().getSource().getFileObject().getPath();
        }
        ArrayList<Identifier> parameters = new ArrayList<Identifier>(functionNode.getParameters().size());
        for (IdentNode node : functionNode.getParameters()) {
            Identifier param = ModelElementFactory.create(parserResult, node);
            if (param == null) continue;
            parameters.add(param);
        }
        if (fqName.size() > 1) {
            List<Identifier> objectName = fqName.subList(0, fqName.size() - 1);
            parentObject = isAnnonymous ? globalObject : ModelUtils.getJsObject(modelBuilder, objectName, false);
            result = new JsFunctionImpl(modelBuilder.getCurrentDeclarationFunction(), parentObject, fqName.get(fqName.size() - 1), parameters, new OffsetRange(start, end), parserResult.getSnapshot().getMimeType(), null);
            if (parentObject instanceof JsFunction && !"prototype".equals(parentObject.getName())) {
                result.addModifier(Modifier.STATIC);
            }
        } else {
            result = new JsFunctionImpl(modelBuilder.getCurrentDeclarationFunction(), parentObject, fqName.get(fqName.size() - 1), parameters, new OffsetRange(start, end), parserResult.getSnapshot().getMimeType(), null);
        }
        String propertyName = result.getDeclarationName().getName();
        if (parentObject == null) {
            parentObject = globalObject;
        }
        JsObject property = parentObject.getProperty(propertyName);
        parentObject.addProperty(result.getDeclarationName().getName(), result);
        if (property != null) {
            if (property.getDeclarationName() != null) {
                result.addOccurrence(property.getDeclarationName().getOffsetRange());
            }
            for (Occurrence occurrence : property.getOccurrences()) {
                result.addOccurrence(occurrence.getOffsetRange());
            }
        }
        if ((docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult)) != null) {
            result.setDocumentation(docHolder.getDocumentation((Node)functionNode));
        }
        result.setAnonymous(isAnnonymous);
        return result;
    }

    @NonNull
    static JsFunctionImpl createVirtualFunction(ParserResult parserResult, JsObject parentObject, Identifier name, int paramCount) {
        ArrayList<Identifier> params = new ArrayList<Identifier>(paramCount);
        if (paramCount == 1) {
            params.add(new Identifier("param", OffsetRange.NONE));
        } else {
            for (int i = 0; i < paramCount; ++i) {
                params.add(new Identifier("param" + (i + 1), OffsetRange.NONE));
            }
        }
        JsFunctionImpl virtual = new JsFunctionImpl(parserResult.getSnapshot().getSource().getFileObject(), parentObject, name, params, parserResult.getSnapshot().getMimeType(), null);
        if (virtual.hasExactName()) {
            virtual.addOccurrence(name.getOffsetRange());
        }
        return virtual;
    }

    @CheckForNull
    static Identifier create(ParserResult parserResult, IdentNode node) {
        return ModelElementFactory.create(parserResult, node.getName(), node.getStart(), node.getFinish());
    }

    @CheckForNull
    static Identifier create(ParserResult parserResult, LiteralNode node) {
        return ModelElementFactory.create(parserResult, node.getString(), node.getStart(), node.getFinish());
    }

    @CheckForNull
    static Identifier create(ParserResult parserResult, String name, int start, int end) {
        if (EmbeddingHelper.containsGeneratedIdentifier(name)) {
            return null;
        }
        return new Identifier(name, new OffsetRange(start, end));
    }

    @CheckForNull
    static JsObjectImpl create(ParserResult parserResult, ObjectNode objectNode, List<Identifier> fqName, ModelBuilder modelBuilder, boolean belongsToParent) {
        JsDocumentationHolder docHolder;
        if (EmbeddingHelper.containsGeneratedIdentifier(fqName.get(fqName.size() - 1).getName())) {
            return null;
        }
        JsObjectImpl scope = modelBuilder.getCurrentObject();
        JsObject parent = scope;
        Identifier name = fqName.get(fqName.size() - 1);
        if (!belongsToParent) {
            List<Identifier> objectName = fqName.size() > 1 ? fqName.subList(0, fqName.size() - 1) : fqName;
            parent = ModelUtils.getJsObject(modelBuilder, objectName, false);
            if (parent != null) {
                parent = parent.getParent();
            }
            if (parent == null) {
                parent = modelBuilder.getGlobal();
            }
        }
        JsObject result = parent.getProperty(name.getName());
        JsObjectImpl newObject = new JsObjectImpl(parent, name, new OffsetRange(objectNode.getStart(), objectNode.getFinish()), parserResult.getSnapshot().getMimeType(), null);
        newObject.setDeclared(true);
        if (result != null) {
            for (String propertyName : result.getProperties().keySet()) {
                newObject.addProperty(propertyName, result.getProperty(propertyName));
            }
        }
        if ((docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult)) != null) {
            newObject.setDeprecated(docHolder.isDeprecated((Node)objectNode));
            newObject.setDocumentation(docHolder.getDocumentation((Node)objectNode));
        }
        parent.addProperty(name.getName(), newObject);
        if (newObject.hasExactName()) {
            newObject.addOccurrence(newObject.getDeclarationName().getOffsetRange());
        }
        return newObject;
    }

    @CheckForNull
    static JsArrayImpl create(ParserResult parserResult, LiteralNode.ArrayLiteralNode aNode, List<Identifier> fqName, ModelBuilder modelBuilder, boolean belongsToParent, JsObject suggestedParent) {
        JsDocumentationHolder docHolder;
        if (EmbeddingHelper.containsGeneratedIdentifier(fqName.get(fqName.size() - 1).getName())) {
            return null;
        }
        JsObject parent = suggestedParent != null ? suggestedParent : modelBuilder.getCurrentObject();
        Identifier name = fqName.get(fqName.size() - 1);
        if (!belongsToParent) {
            List<Identifier> objectName = fqName.size() > 1 ? fqName.subList(0, fqName.size() - 1) : fqName;
            parent = ModelUtils.getJsObject(modelBuilder, objectName, false);
        }
        JsObject result = parent.getProperty(name.getName());
        JsArrayImpl newObject = new JsArrayImpl(parent, name, new OffsetRange(aNode.getStart(), aNode.getFinish()), parserResult.getSnapshot().getMimeType(), null);
        newObject.setDeclared(true);
        if (result != null) {
            for (String propertyName : result.getProperties().keySet()) {
                newObject.addProperty(propertyName, result.getProperty(propertyName));
            }
            for (Occurrence occurence : result.getOccurrences()) {
                newObject.addOccurrence(occurence.getOffsetRange());
            }
            if (result.isDeclared()) {
                newObject.getModifiers().clear();
                newObject.getModifiers().addAll(result.getModifiers());
                newObject.setDeclarationName(result.getDeclarationName());
            }
        }
        if ((docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult)) != null) {
            newObject.setDeprecated(docHolder.isDeprecated((Node)aNode));
            newObject.setDocumentation(docHolder.getDocumentation((Node)aNode));
        }
        parent.addProperty(name.getName(), newObject);
        if (newObject.hasExactName() && newObject.getDeclarationName() != null) {
            newObject.addOccurrence(newObject.getDeclarationName().getOffsetRange());
        }
        return newObject;
    }

    @NonNull
    static JsObjectImpl createAnonymousObject(ParserResult parserResult, ObjectNode objectNode, ModelBuilder modelBuilder) {
        String name = modelBuilder.getUnigueNameForAnonymObject((org.netbeans.modules.csl.spi.ParserResult)parserResult);
        AnonymousObject result = new AnonymousObject((JsObject)modelBuilder.getCurrentDeclarationFunction(), name, new OffsetRange(objectNode.getStart(), objectNode.getFinish()), parserResult.getSnapshot().getMimeType(), null);
        modelBuilder.getCurrentDeclarationFunction().addProperty(name, result);
        JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult);
        if (docHolder != null) {
            result.setDocumentation(docHolder.getDocumentation((Node)objectNode));
            result.setDeprecated(docHolder.isDeprecated((Node)objectNode));
        }
        return result;
    }

    @NonNull
    static JsArrayImpl createAnonymousObject(ParserResult parserResult, LiteralNode.ArrayLiteralNode aNode, ModelBuilder modelBuilder) {
        String name = modelBuilder.getUnigueNameForAnonymObject((org.netbeans.modules.csl.spi.ParserResult)parserResult);
        AnonymousObject.AnonymousArray result = new AnonymousObject.AnonymousArray((JsObject)modelBuilder.getCurrentDeclarationFunction(), name, new OffsetRange(aNode.getStart(), aNode.getFinish()), parserResult.getSnapshot().getMimeType(), null);
        modelBuilder.getCurrentDeclarationFunction().addProperty(name, result);
        JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult);
        if (docHolder != null) {
            result.setDocumentation(docHolder.getDocumentation((Node)aNode));
            result.setDeprecated(docHolder.isDeprecated((Node)aNode));
        }
        return result;
    }

    @CheckForNull
    static JsObjectImpl create(ParserResult parserResult, PropertyNode propertyNode, Identifier name, ModelBuilder modelBuilder, boolean belongsToParent) {
        if (EmbeddingHelper.containsGeneratedIdentifier(name.getName())) {
            return null;
        }
        JsObjectImpl scope = modelBuilder.getCurrentObject();
        JsObjectImpl property = new JsObjectImpl(scope, name, name.getOffsetRange(), parserResult.getSnapshot().getMimeType(), null);
        JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((ParserResult)parserResult);
        property.setDocumentation(docHolder.getDocumentation((Node)propertyNode));
        property.setDeprecated(docHolder.isDeprecated((Node)propertyNode));
        if (property.hasExactName()) {
            property.addOccurrence(property.getDeclarationName().getOffsetRange());
        }
        return property;
    }
}

