/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.api;

import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class DebuggerOptions {
    private static final String DEBUGGER_PREFS = "nodejs.debugger";
    private static final String PROP_LIVE_EDIT = "liveEdit";
    private static final String PROP_BRK_1ST = "breakOn1stLine";
    private static final String PROP_DEBUGGER_PROTOCOL = "debuggerProtocol";
    private static final DebuggerOptions INSTANCE = new DebuggerOptions();
    private final Preferences prefs = NbPreferences.forModule(DebuggerOptions.class).node("nodejs.debugger");

    private DebuggerOptions() {
    }

    public static DebuggerOptions getInstance() {
        return INSTANCE;
    }

    public boolean isLiveEdit() {
        return this.prefs.getBoolean(PROP_LIVE_EDIT, true);
    }

    public void setLiveEdit(boolean doLiveEdit) {
        this.prefs.putBoolean(PROP_LIVE_EDIT, doLiveEdit);
    }

    public boolean isBreakAtFirstLine() {
        return this.prefs.getBoolean(PROP_BRK_1ST, true);
    }

    public void setBreakAtFirstLine(boolean brk1st) {
        this.prefs.putBoolean(PROP_BRK_1ST, brk1st);
    }

    public String getDebuggerProtocol() {
        return this.prefs.get(PROP_DEBUGGER_PROTOCOL, null);
    }

    public void setDebuggerProtocol(String brk1st) {
        this.prefs.put(PROP_DEBUGGER_PROTOCOL, brk1st);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        this.prefs.addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        this.prefs.removePreferenceChangeListener(listener);
    }
}

