/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javascript.karma.exec.KarmaExecutable;
import org.netbeans.modules.javascript.karma.ui.options.Bundle;
import org.netbeans.modules.javascript.karma.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class KarmaOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(KarmaOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel hintLabel;
    private JLabel installLabel;
    private JButton karmaBrowseButton;
    private JLabel karmaLabel;
    private JButton karmaSearchButton;
    private JTextField karmaTextField;

    KarmaOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.hintLabel.setText(Bundle.KarmaOptionsPanel_karma_hint(KarmaExecutable.KARMA_NAME));
        this.karmaTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getKarma() {
        return this.karmaTextField.getText();
    }

    public void setKarma(String karma) {
        this.karmaTextField.setText(karma);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.karmaLabel = new JLabel();
        this.karmaTextField = new JTextField();
        this.karmaBrowseButton = new JButton();
        this.karmaSearchButton = new JButton();
        this.hintLabel = new JLabel();
        this.installLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.karmaLabel.setLabelFor(this.karmaTextField);
        Mnemonics.setLocalizedText((JLabel)this.karmaLabel, (String)NbBundle.getMessage(KarmaOptionsPanel.class, (String)"KarmaOptionsPanel.karmaLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.karmaBrowseButton, (String)NbBundle.getMessage(KarmaOptionsPanel.class, (String)"KarmaOptionsPanel.karmaBrowseButton.text"));
        this.karmaBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KarmaOptionsPanel.this.karmaBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.karmaSearchButton, (String)NbBundle.getMessage(KarmaOptionsPanel.class, (String)"KarmaOptionsPanel.karmaSearchButton.text"));
        this.karmaSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KarmaOptionsPanel.this.karmaSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(KarmaOptionsPanel.class, (String)"KarmaOptionsPanel.installLabel.text"));
        this.installLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                KarmaOptionsPanel.this.installLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                KarmaOptionsPanel.this.installLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.karmaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.karmaTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.karmaBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.karmaSearchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.karmaLabel).addComponent(this.karmaTextField, -2, -1, -2).addComponent(this.karmaBrowseButton).addComponent(this.karmaSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hintLabel).addComponent(this.installLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void karmaBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(KarmaOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.KarmaOptionsPanel_karma_browse_title()).showOpenDialog();
        if (file != null) {
            this.karmaTextField.setText(file.getAbsolutePath());
        }
    }

    private void karmaSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> iterator = FileUtils.findFileOnUsersPath(KarmaExecutable.KARMA_NAME).iterator();
        if (iterator.hasNext()) {
            String karma = iterator.next();
            this.karmaTextField.setText(new File(karma).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.KarmaOptionsPanel_karma_none());
    }

    private void installLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://karma-runner.github.io/latest/intro/installation.html"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            KarmaOptionsPanel.this.fireChange();
        }
    }
}

