/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.mapping;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.exec.KarmaServers;
import org.netbeans.modules.web.clientproject.api.ProjectDirectoriesProvider;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class ServerMapping {
    private static final Logger LOGGER = Logger.getLogger(ServerMapping.class.getName());
    private static final String BASE_PREFIX = "base/";
    private static final String ABSOLUTE_PREFIX = "absolute";

    public FileObject fromServer(Project project, URL serverUrl) {
        String serverUrlString = WebUtils.urlToString((URL)serverUrl);
        String prefix = KarmaServers.getInstance().getServerUrl(project, ABSOLUTE_PREFIX);
        if (prefix == null) {
            return null;
        }
        if (serverUrlString.startsWith(prefix)) {
            String absolutePath = serverUrlString.substring(prefix.length());
            try {
                absolutePath = URLDecoder.decode(absolutePath, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            if (Utilities.isWindows()) {
                absolutePath = absolutePath.replace('/', '\\');
            }
            return FileUtil.toFileObject((File)new File(absolutePath));
        }
        prefix = KarmaServers.getInstance().getServerUrl(project, BASE_PREFIX);
        assert (prefix != null);
        if (!serverUrlString.startsWith(prefix)) {
            return null;
        }
        assert (prefix.endsWith("/")) : prefix;
        String projectRelativePath = serverUrlString.substring(prefix.length());
        try {
            projectRelativePath = URLDecoder.decode(projectRelativePath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        if (!projectRelativePath.isEmpty()) {
            return project.getProjectDirectory().getFileObject(projectRelativePath);
        }
        return null;
    }

    public URL toServer(Project project, FileObject projectFile) {
        String serverUrl = KarmaServers.getInstance().getServerUrl(project, null);
        if (serverUrl == null) {
            return null;
        }
        assert (serverUrl.endsWith("/")) : serverUrl;
        URL absoluteUrl = this.createAbsoluteUrl(serverUrl, projectFile);
        if (KarmaServers.getInstance().servesUrl(project, absoluteUrl)) {
            return absoluteUrl;
        }
        FileObject projectDirectory = project.getProjectDirectory();
        String filePath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)projectFile);
        if (filePath != null) {
            URL relativeUrl = this.createUrl(serverUrl, BASE_PREFIX, filePath);
            if (KarmaServers.getInstance().servesUrl(project, relativeUrl)) {
                return relativeUrl;
            }
        }
        return null;
    }

    private URL createAbsoluteUrl(String server, FileObject file) {
        assert (server.endsWith("/")) : server;
        assert (file != null);
        return this.createUrl(server, ABSOLUTE_PREFIX, FileUtil.toFile((FileObject)file).getAbsolutePath());
    }

    private URL createUrl(String server, String prefix, String filePath) {
        assert (server.endsWith("/")) : server;
        String urlPath = Utilities.isWindows() ? filePath.replace('\\', '/') : filePath;
        urlPath = urlPath.replace(" ", "%20");
        try {
            return new URL(server + prefix + urlPath);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    @CheckForNull
    private FileObject getTestsFolder(Project project) {
        ProjectDirectoriesProvider directoriesProvider = (ProjectDirectoriesProvider)project.getLookup().lookup(ProjectDirectoriesProvider.class);
        if (directoriesProvider == null) {
            return null;
        }
        return directoriesProvider.getTestDirectory(false);
    }

    private boolean isUnderneath(FileObject root, FileObject folder) {
        return root.equals(folder) || FileUtil.isParentOf((FileObject)root, (FileObject)folder);
    }
}

