/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.gulp.options.GulpOptions;
import org.netbeans.modules.javascript.gulp.options.GulpOptionsValidator;
import org.netbeans.modules.javascript.gulp.ui.options.GulpOptionsPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class GulpOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_CATEGORY = "Html5";
    public static final String OPTIONS_SUBCATEGORY = "Gulp";
    public static final String OPTIONS_PATH = "Html5/Gulp";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GulpOptionsPanel gulpOptionsPanel;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setGulp(this.getGulpOptions().getGulp());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GulpOptionsPanelController.this.getGulpOptions().setGulp(GulpOptionsPanelController.this.getPanel().getGulp());
                GulpOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setGulp(this.getGulpOptions().getGulp());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        GulpOptionsPanel panel = this.getPanel();
        ValidationResult result = new GulpOptionsValidator().validateGulp(panel.getGulp()).getResult();
        if (result.hasErrors()) {
            panel.setError(result.getFirstErrorMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(result.getFirstWarningMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getGulpOptions().getGulp();
        String current = this.getPanel().getGulp().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.gulp.ui.options.GulpOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private GulpOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.gulpOptionsPanel == null) {
            this.gulpOptionsPanel = new GulpOptionsPanel();
            this.gulpOptionsPanel.addChangeListener(this);
        }
        return this.gulpOptionsPanel;
    }

    private GulpOptions getGulpOptions() {
        return GulpOptions.getInstance();
    }
}

