/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt;

import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.Bundle;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.file.GruntTasks;
import org.netbeans.modules.javascript.grunt.file.Gruntfile;
import org.netbeans.modules.javascript.grunt.preferences.GruntPreferences;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class GruntBuildTool
implements BuildToolImplementation {
    private static final Logger LOGGER = Logger.getLogger(GruntBuildTool.class.getName());
    public static final String IDENTIFIER = "Grunt";
    private final Project project;
    private final Gruntfile projectGruntfile;
    private final GruntTasks projectGruntTasks;
    private final GruntPreferences gruntPreferences;
    final ConcurrentMap<FileObject, GruntTasks> gruntTasks = new ConcurrentHashMap<FileObject, GruntTasks>();
    private final ChangeListener cleanupListener = new CleanupListener();

    public GruntBuildTool(Project project) {
        assert (project != null);
        this.project = project;
        this.projectGruntfile = Gruntfile.create(project.getProjectDirectory());
        this.projectGruntTasks = GruntTasks.create(project, this.projectGruntfile);
        this.gruntPreferences = new GruntPreferences(project);
    }

    @NonNull
    public static GruntBuildTool forProject(Project project) {
        GruntBuildTool buildTool = GruntBuildTool.inProject(project);
        assert (buildTool != null) : "GruntBuildTool should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return buildTool;
    }

    @CheckForNull
    public static GruntBuildTool inProject(Project project) {
        assert (project != null);
        return (GruntBuildTool)project.getLookup().lookup(GruntBuildTool.class);
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.GruntBuildTool_name();
    }

    public Gruntfile getProjectGruntfile() {
        return this.projectGruntfile;
    }

    public GruntTasks getProjectGruntTasks() {
        return this.projectGruntTasks;
    }

    public GruntTasks getGruntTasks(@NullAllowed FileObject gruntfile) {
        if (gruntfile == null || gruntfile.getParent().equals(this.project.getProjectDirectory())) {
            return this.getProjectGruntTasks();
        }
        GruntTasks tasks = (GruntTasks)this.gruntTasks.get(gruntfile);
        if (tasks != null) {
            return tasks;
        }
        Gruntfile file = Gruntfile.create(gruntfile.getParent());
        tasks = GruntTasks.create(this.project, file);
        GruntTasks currentTasks = this.gruntTasks.putIfAbsent(gruntfile, tasks);
        if (currentTasks != null) {
            return currentTasks;
        }
        file.addChangeListener(WeakListeners.change((ChangeListener)this.cleanupListener, (Object)file));
        return tasks;
    }

    public GruntPreferences getGruntPreferences() {
        return this.gruntPreferences;
    }

    public boolean isEnabled() {
        return this.projectGruntfile.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(String commandId, boolean waitFinished, boolean warnUser) {
        assert (this.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        assert (this.projectGruntfile.exists()) : this.project.getProjectDirectory().getNameExt();
        String gruntBuild = this.gruntPreferences.getTask(commandId);
        if (gruntBuild != null) {
            GruntExecutable grunt = GruntExecutable.getDefault(this.project, warnUser);
            if (grunt == null) return true;
            GruntUtils.logUsageGruntBuild();
            Future<Integer> result = grunt.run(gruntBuild.split(" "));
            if (!waitFinished) return true;
            try {
                result.get();
                return true;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return true;
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return true;
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!warnUser) return true;
            }
            return true;
        } else {
            Object option;
            if (!warnUser || (option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.GruntBuildTool_configure(), 0))) != NotifyDescriptor.YES_OPTION) return true;
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(IDENTIFIER, null);
        }
        return true;
    }

    private final class CleanupListener
    implements ChangeListener {
        private CleanupListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Iterator iterator = GruntBuildTool.this.gruntTasks.keySet().iterator();
            while (iterator.hasNext()) {
                FileObject gruntfile = (FileObject)iterator.next();
                if (gruntfile.isValid()) continue;
                LOGGER.log(Level.FINE, "Removing invalid grunt file {0}", gruntfile);
                iterator.remove();
            }
        }
    }
}

