/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.breakpoints;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.filesystems.FileObject;

public class JSBreakpointsManager
extends DebuggerManagerAdapter {
    private final Set<CDTDebugger> activeDebuggers = new CopyOnWriteArraySet<CDTDebugger>();
    private final ThreadLocal<Boolean> breakpointsAddedDuringInit = new ThreadLocal();

    public void engineAdded(DebuggerEngine engine) {
        CDTDebugger dbg = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (dbg != null) {
            this.activeDebuggers.add(dbg);
            this.submitExistingBreakpoints(dbg);
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        CDTDebugger dbg = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (dbg != null) {
            this.activeDebuggers.remove(dbg);
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return;
        }
        if (this.breakpointsAddedDuringInit.get() != null) {
            this.breakpointsAddedDuringInit.set(true);
        }
        JSLineBreakpoint lb = (JSLineBreakpoint)breakpoint;
        for (CDTDebugger dbg : this.activeDebuggers) {
            ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
            FileObject fo = lb.getFileObject();
            if ((fo != null || !scriptsHandler.containsRemoteFile(lb.getURL())) && !scriptsHandler.containsLocalFile(fo)) continue;
            this.submit(lb, dbg);
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return;
        }
        JSLineBreakpoint lb = (JSLineBreakpoint)breakpoint;
        for (CDTDebugger dbg : this.activeDebuggers) {
            if (!dbg.getScriptsHandler().containsLocalFile(lb.getFileObject())) continue;
            dbg.getBreakpointsHandler().remove(lb);
        }
    }

    private void submitExistingBreakpoints(CDTDebugger dbg) {
        this.breakpointsAddedDuringInit.set(false);
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        Boolean added = this.breakpointsAddedDuringInit.get();
        this.breakpointsAddedDuringInit.remove();
        if (added.booleanValue()) {
            return;
        }
        ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
        for (Breakpoint b : breakpoints) {
            JSLineBreakpoint lb;
            FileObject fo;
            if (!(b instanceof JSLineBreakpoint) || ((fo = (lb = (JSLineBreakpoint)b).getFileObject()) != null || !scriptsHandler.containsRemoteFile(lb.getURL())) && !scriptsHandler.containsLocalFile(fo)) continue;
            this.submit(lb, dbg);
        }
    }

    private void submit(JSLineBreakpoint b, CDTDebugger dbg) {
        dbg.getBreakpointsHandler().add(b);
    }
}

