/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentFactory;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WildflyClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(WildflyDeploymentFactory.class.getName());
    private final boolean patchXnio;

    public WildflyClassLoader(URL[] urls, ClassLoader parent, boolean patchXnio) throws MalformedURLException, RuntimeException {
        super(urls, parent);
        this.patchXnio = patchXnio;
    }

    public static WildflyClassLoader createWildFlyClassLoader(String serverRoot) {
        try {
            ArrayList<URL> urlList = new ArrayList<URL>(2);
            Path serverRootPath = Paths.get(serverRoot, new String[0]);
            Path jbossCliClientJar = Paths.get(serverRootPath.toString(), "bin", "client", "jboss-cli-client.jar");
            urlList.add(jbossCliClientJar.toUri().toURL());
            Path modulePath = serverRootPath.resolve("modules");
            WildflyClassLoader.findJarAddUrl(urlList, modulePath, "glob:**/*/controller/main/wildfly-controller-*.jar");
            WildflyPluginUtils.Version version = WildflyPluginUtils.getServerVersion(new File(serverRoot));
            boolean shouldPatchXnio = WildflyPluginUtils.WILDFLY_8_0_0.compareToIgnoreUpdate(version) <= 0;
            return new WildflyClassLoader(urlList.toArray(new URL[0]), WildflyDeploymentFactory.class.getClassLoader(), shouldPatchXnio);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findJarAddUrl(List<URL> urlList, Path folder, String pathMatcherRaw) {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pathMatcherRaw);
        try (Stream<Path> walk = null;){
            walk = Files.walk(folder, new FileVisitOption[0]);
            Optional<Path> firstJarMatching = walk.filter(pathMatcher::matches).findFirst();
            if (firstJarMatching.isPresent()) {
                LOGGER.log(Level.INFO, "Adding {0} to the classpath", firstJarMatching.get().toString());
                urlList.add(firstJarMatching.get().toUri().toURL());
            }
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions p = new Permissions();
        p.add(new AllPermission());
        return p;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.contains("jndi.properties")) {
            return Collections.enumeration(Collections.emptyList());
        }
        return super.getResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.patchXnio && "org.xnio.nio.WorkerThread".equals(name)) {
            Class<?> clazz;
            block11: {
                LOGGER.log(Level.INFO, "Patching the issue #249135");
                String path = name.replace('.', '/').concat(".class");
                InputStream is = super.getResourceAsStream(path);
                try {
                    ClassReader cr = new ClassReader(is);
                    final WildflyClassLoader ld = this;
                    ClassWriter cw = new ClassWriter(cr, 2){

                        protected String getCommonSuperClass(String string, String string1) {
                            if ("org/xnio/nio/NioHandle".equals(string) || "org/xnio/nio/NioHandle".equals(string1)) {
                                return "java/lang/Object";
                            }
                            return super.getCommonSuperClass(string, string1);
                        }

                        protected ClassLoader getClassLoader() {
                            return ld;
                        }
                    };
                    ClassNode node = new ClassNode(589824);
                    cr.accept((ClassVisitor)node, 0);
                    block7: for (MethodNode m : node.methods) {
                        if (!"execute".equals(m.name) || !"(Ljava/lang/Runnable;)V".equals(m.desc)) continue;
                        InsnList list = m.instructions;
                        ListIterator it = list.iterator();
                        while (it.hasNext()) {
                            AbstractInsnNode possibleThrow;
                            AbstractInsnNode n = (AbstractInsnNode)it.next();
                            if (!(n instanceof MethodInsnNode)) continue;
                            MethodInsnNode mn = (MethodInsnNode)n;
                            if (!"org/xnio/nio/Log".equals(mn.owner) || !"threadExiting".equals(mn.name) || !"()Ljava/util/concurrent/RejectedExecutionException;".equals(mn.desc) || !it.hasNext() || (possibleThrow = (AbstractInsnNode)it.next()).getOpcode() != 191) continue;
                            it.set(new InsnNode(87));
                            break block7;
                        }
                        break block7;
                    }
                    node.accept((ClassVisitor)cw);
                    byte[] newBytecode = cw.toByteArray();
                    clazz = super.defineClass(name, newBytecode, 0, newBytecode.length);
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
                is.close();
            }
            return clazz;
        }
        return super.findClass(name);
    }
}

