/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ant.ui.logicalview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceSupport;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.javaee.project.api.ant.DeployOnSaveUtils;
import org.netbeans.modules.javaee.project.api.ant.ui.logicalview.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class AbstractLogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor RP = new RequestProcessor("AbstractLogicalViewProvider.RP");
    private static final Logger LOGGER = Logger.getLogger(AbstractLogicalViewProvider.class.getName());
    public static final String JAVA_PLATFORM = "platform.active";
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final AtomicBoolean listensOnProblems = new AtomicBoolean();
    private PropertyChangeListener pcl;
    private ConnectionListener cl;
    private InstanceListener il;
    private ConfigurationFilesListener cfl;
    private Map<URL, Object[]> activeLibManLocs;
    private final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            boolean _brokenServerLibrary;
            boolean _brokenDataSource;
            boolean _brokenServer;
            boolean _deployOnSaveDisabled;
            boolean _broken;
            if (!ProjectManager.getDefault().isValid(AbstractLogicalViewProvider.this.project)) {
                return;
            }
            boolean old = AbstractLogicalViewProvider.this.broken;
            if (old != (_broken = AbstractLogicalViewProvider.this.hasBrokenLinks())) {
                AbstractLogicalViewProvider.this.setBroken(_broken);
            }
            if ((old = AbstractLogicalViewProvider.this.deployOnSaveDisabled) != (_deployOnSaveDisabled = AbstractLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled())) {
                AbstractLogicalViewProvider.this.setDeployOnSaveDisabled(_deployOnSaveDisabled);
            }
            if ((old = AbstractLogicalViewProvider.this.brokenServer) != (_brokenServer = AbstractLogicalViewProvider.this.hasBrokenServer())) {
                AbstractLogicalViewProvider.this.setBrokenServer(_brokenServer);
            }
            if ((old = AbstractLogicalViewProvider.this.brokenDataSource) != (_brokenDataSource = AbstractLogicalViewProvider.this.hasBrokenDataSource())) {
                AbstractLogicalViewProvider.this.setBrokenDataSource(_brokenDataSource);
            }
            if ((old = AbstractLogicalViewProvider.this.brokenServerLibrary) != (_brokenServerLibrary = AbstractLogicalViewProvider.this.hasBrokenServerLibrary())) {
                AbstractLogicalViewProvider.this.setBrokenServerLibrary(_brokenServerLibrary);
            }
        }
    });
    private boolean broken;
    private boolean deployOnSaveDisabled;
    private boolean brokenServer;
    private boolean brokenDataSource;
    private boolean brokenServerLibrary;

    protected AbstractLogicalViewProvider(Project project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver, J2eeModuleProvider j2eeModuleProvider) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
        assert (j2eeModuleProvider != null);
        this.registerListeners(j2eeModuleProvider);
    }

    private void registerListeners(J2eeModuleProvider j2eeModuleProvider) {
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.il = new InstanceListener(){

            public void instanceAdded(String serverInstanceID) {
                AbstractLogicalViewProvider.this.testBroken();
            }

            public void instanceRemoved(String serverInstanceID) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.cfl = new ConfigurationFilesListener(){

            public void fileCreated(FileObject added) {
                AbstractLogicalViewProvider.this.testBroken();
            }

            public void fileDeleted(FileObject removed) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.cl = new ConnectionListener(){

            public void connectionsChanged() {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.evaluator.addPropertyChangeListener(this.pcl);
        j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.il, (Object)j2eeModuleProvider));
        ConnectionManager.getDefault().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this.cl, (Object)ConnectionManager.getDefault()));
    }

    protected boolean isInitialized() {
        return this.project.getLookup() != null;
    }

    public Node findPath(Node root, Object target) {
        Project proj = (Project)root.getLookup().lookup(Project.class);
        if (proj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            return this.findPath(root, proj, (FileObject)target);
        }
        return null;
    }

    protected Node findPath(Node root, Project proj, FileObject fo) {
        if (AbstractLogicalViewProvider.isOtherProjectSource(fo, proj)) {
            return null;
        }
        for (Node n : root.getChildren().getNodes(true)) {
            Node result = PackageView.findPath((Node)n, (Object)fo);
            if (result == null) continue;
            return result;
        }
        Node result = this.findNodeInConfigFiles(root, fo);
        if (result != null) {
            return result;
        }
        result = this.findNodeInServerFiles(root, fo);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        if (me.equals(owner)) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)owner);
        if (AbstractLogicalViewProvider.isInSourceGroup(fo, sources.getSourceGroups("java"))) {
            return true;
        }
        if (AbstractLogicalViewProvider.isInSourceGroup(fo, sources.getSourceGroups("doc_root"))) {
            return true;
        }
        return AbstractLogicalViewProvider.isInSourceGroup(fo, sources.getSourceGroups("web_inf"));
    }

    private static boolean isInSourceGroup(@NonNull FileObject fo, SourceGroup ... sgs) {
        for (SourceGroup sg : sgs) {
            if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    protected Node findNodeInDocBase(Node root, FileObject fo, String docBasePropertyName) {
        String prop = this.evaluator.getProperty(docBasePropertyName);
        if (prop == null) {
            return null;
        }
        FileObject rootfo = this.helper.getAntProjectHelper().resolveFileObject(prop);
        if (rootfo == null) {
            return null;
        }
        String relPath = FileUtil.getRelativePath((FileObject)rootfo, (FileObject)fo);
        if (relPath == null) {
            return null;
        }
        int idx = relPath.lastIndexOf(47);
        relPath = idx != -1 ? relPath.substring(0, idx) : "";
        StringTokenizer st = new StringTokenizer(relPath, "/");
        Node result = NodeOp.findChild((Node)root, (String)rootfo.getName());
        if (result == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if ((result = NodeOp.findChild((Node)result, (String)st.nextToken())) != null) continue;
            return null;
        }
        for (Node child : result.getChildren().getNodes(true)) {
            DataObject dobj = (DataObject)child.getLookup().lookup(DataObject.class);
            if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
            result = child;
            break;
        }
        return result;
    }

    private Node findNodeInConfigFiles(Node root, FileObject fo) {
        String nodeName;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            nodeName = dobj.getName();
        }
        catch (DataObjectNotFoundException e) {
            nodeName = fo.getName();
        }
        Node configFiles = root.getChildren().findChild("configurationFiles");
        if (configFiles == null) {
            return null;
        }
        return NodeOp.findChild((Node)configFiles, (String)nodeName);
    }

    private Node findNodeInServerFiles(Node root, FileObject fo) {
        Node configFiles = root.getChildren().findChild("setup");
        if (configFiles == null) {
            return null;
        }
        return NodeOp.findChild((Node)configFiles, (String)fo.getName());
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void testBroken() {
        if (this.isInitialized()) {
            ProjectProblemsProvider problems;
            if (this.listensOnProblems.compareAndSet(false, true) && (problems = (ProjectProblemsProvider)this.project.getLookup().lookup(ProjectProblemsProvider.class)) != null) {
                problems.addPropertyChangeListener(this.pcl);
            }
            this.task.schedule(500);
        }
    }

    public boolean hasBrokenLinks() {
        return ProjectProblems.isBroken((Project)this.project);
    }

    public abstract String[] getBreakableProperties();

    public String[] getPlatformProperties() {
        return new String[]{JAVA_PLATFORM};
    }

    protected final Project getProject() {
        return this.project;
    }

    protected final String[] createListOfBreakableProperties(SourceRoots sources, SourceRoots tests, String[] otherBreakableProperties) {
        String[] srcRootProps = sources.getRootProperties();
        String[] testRootProps = tests.getRootProperties();
        String[] result = new String[otherBreakableProperties.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(otherBreakableProperties, 0, result, 0, otherBreakableProperties.length);
        System.arraycopy(srcRootProps, 0, result, otherBreakableProperties.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, otherBreakableProperties.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    public static JavaPlatform getActivePlatform(String activePlatformId) {
        JavaPlatform[] installedPlatforms;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            return pm.getDefaultPlatform();
        }
        for (JavaPlatform p : installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null))) {
            String antName = (String)p.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return p;
        }
        return null;
    }

    private boolean isDeployOnSaveSupportedAndDisabled() {
        boolean deployOnSaveEnabled = Boolean.valueOf(this.evaluator.getProperty("j2ee.deploy.on.save"));
        if (deployOnSaveEnabled) {
            return false;
        }
        boolean deployOnSaveSupported = false;
        try {
            String instanceId = this.evaluator.getProperty("j2ee.server.instance");
            if (instanceId != null) {
                deployOnSaveSupported = Deployment.getDefault().getServerInstance(instanceId).isDeployOnSaveSupported();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return deployOnSaveSupported;
    }

    protected abstract void setServerInstance(Project var1, UpdateHelper var2, String var3);

    private void setBroken(boolean broken) {
        this.broken = broken;
        this.changeSupport.fireChange();
    }

    private void setDeployOnSaveDisabled(boolean value) {
        this.deployOnSaveDisabled = value;
        this.changeSupport.fireChange();
    }

    private void setBrokenDataSource(boolean brokenDataSource) {
        this.brokenDataSource = brokenDataSource;
        this.changeSupport.fireChange();
    }

    private void setBrokenServer(boolean brokenServer) {
        this.brokenServer = brokenServer;
        this.changeSupport.fireChange();
    }

    private void setBrokenServerLibrary(boolean brokenServerLibrary) {
        this.brokenServerLibrary = brokenServerLibrary;
        this.changeSupport.fireChange();
    }

    public static Action brokenLinksActionFactory() {
        return new ActionFactory(1);
    }

    public static Action brokenServerActionFactory() {
        return new ActionFactory(2);
    }

    public static Action brokenDataSourceActionFactory() {
        return new ActionFactory(3);
    }

    public static Action brokenServerLibraryActionFactory() {
        return new ActionFactory(4);
    }

    public static Action redeploy() {
        return ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)NbBundle.getBundle(AbstractLogicalViewProvider.class).getString("LBL_RedeployAction_Name"), null);
    }

    private boolean hasBrokenServer() {
        String servInstID = this.evaluator.getProperty("j2ee.server.instance");
        return BrokenServerSupport.isBroken((String)servInstID);
    }

    private boolean isVisualWebLegacyProject() {
        String version;
        boolean isLegacyProject = false;
        AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        Element auxElement = ac.getConfigurationFragment("creator-data", "http://www.sun.com/creator/ns", true);
        if (auxElement != null && (version = auxElement.getAttribute("jsf.project.version")) != null && !version.equals("4.0")) {
            isLegacyProject = true;
        }
        return isLegacyProject;
    }

    private boolean hasBrokenDataSource() {
        if (this.isVisualWebLegacyProject()) {
            return false;
        }
        return !BrokenDatasourceSupport.getBrokenDatasources((Project)this.project).isEmpty();
    }

    private boolean hasBrokenServerLibrary() {
        return BrokenServerLibrarySupport.isBroken((Project)this.project);
    }

    private static class OpenManagersWeakListener
    extends WeakReference<PropertyChangeListener>
    implements Runnable,
    PropertyChangeListener {
        public OpenManagersWeakListener(PropertyChangeListener listener) {
            super(listener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LibraryManager.removeOpenManagersPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.get();
            if (listener != null) {
                listener.propertyChange(evt);
            }
        }
    }

    private class BrokenServerLibraryAction
    extends AbstractAction {
        public BrokenServerLibraryAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Broken_Server_Library_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.brokenServerLibrary);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrokenServerLibrarySupport.fixServerLibraries((Project)AbstractLogicalViewProvider.this.project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractLogicalViewProvider.this.testBroken();
                }
            });
        }
    }

    private class BrokenDataSourceAction
    extends AbstractAction {
        public BrokenDataSourceAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Broken_Datasource_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.brokenDataSource);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                BrokenDatasourceSupport.fixDatasources((Project)AbstractLogicalViewProvider.this.project);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    private class BrokenServerAction
    extends AbstractAction {
        public BrokenServerAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.brokenServer);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String instance;
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                Profile j2eeProfile = Profile.fromPropertiesString((String)AbstractLogicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform"));
                if (j2eeProfile == null) {
                    j2eeProfile = Profile.JAVA_EE_5;
                    Logger.getLogger(AbstractLogicalViewProvider.class.getName()).warning("project [" + AbstractLogicalViewProvider.this.project.getProjectDirectory() + "] is missing j2ee.platform. default value will be used instead: " + j2eeProfile);
                    this.updateJ2EESpec(AbstractLogicalViewProvider.this.project, AbstractLogicalViewProvider.this.helper.getAntProjectHelper(), j2eeProfile);
                }
                if ((instance = BrokenServerSupport.selectServer((Profile)j2eeProfile, (J2eeModule.Type)J2eeModule.Type.WAR)) != null) {
                    AbstractLogicalViewProvider.this.setServerInstance(AbstractLogicalViewProvider.this.project, AbstractLogicalViewProvider.this.helper, instance);
                }
                AbstractLogicalViewProvider.this.testBroken();
            }
            catch (IOException ioe) {
                if (!AbstractLogicalViewProvider.this.project.getProjectDirectory().canWrite()) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.ERR_ProjectReadOnly());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        private void updateJ2EESpec(final Project project, final AntProjectHelper helper, final Profile j2eeProfile) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                        projectProps.put("j2ee.platform", j2eeProfile.toPropertiesString());
                        helper.putProperties("nbproject/project.properties", projectProps);
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
    }

    private class BrokenLinksAction
    extends AbstractAction {
        public BrokenLinksAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.broken);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                ProjectProblems.showCustomizer((Project)AbstractLogicalViewProvider.this.project);
                AbstractLogicalViewProvider.this.testBroken();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    public static final class VerifyAction
    extends AbstractAction
    implements ContextAwareAction {
        public VerifyAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_VerifyAction_Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Project p = (Project)actionContext.lookup(Project.class);
            if (p == null) {
                return this;
            }
            J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
            if (provider == null) {
                return this;
            }
            if (!provider.hasVerifierSupport()) {
                return this;
            }
            return ProjectSensitiveActions.projectCommandAction((String)"verify", (String)NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_VerifyAction_Name"), null);
        }
    }

    private static final class ActionFactory
    extends AbstractAction
    implements ContextAwareAction {
        private int mode;

        private ActionFactory(int mode) {
            this.mode = mode;
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Collection p = actionContext.lookupAll(Project.class);
            if (p.size() != 1) {
                return this;
            }
            AbstractLogicalViewProvider lvp = (AbstractLogicalViewProvider)((Project)p.iterator().next()).getLookup().lookup(AbstractLogicalViewProvider.class);
            if (lvp == null) {
                return this;
            }
            switch (this.mode) {
                case 1: {
                    return lvp.new BrokenLinksAction();
                }
                case 2: {
                    return lvp.new BrokenServerAction();
                }
                case 3: {
                    return lvp.new BrokenDataSourceAction();
                }
            }
            return lvp.new BrokenServerLibraryAction();
        }
    }

    public final class LogicalViewRootNode
    extends AbstractNode
    implements ChangeListener {
        private String shortDesc;
        private String actionsFolderLayer;
        private Class helpContext;

        public LogicalViewRootNode(String childrenFolderLayer, String actionsFolderLayer, String iconBase, String shortDesc, Class helpContext) {
            super(NodeFactorySupport.createCompositeChildren((Project)AbstractLogicalViewProvider.this.project, (String)childrenFolderLayer), Lookups.fixed((Object[])new Object[]{AbstractLogicalViewProvider.this.project, AbstractLogicalViewProvider.this.project.getProjectDirectory()}));
            this.shortDesc = shortDesc;
            this.actionsFolderLayer = actionsFolderLayer;
            this.helpContext = helpContext;
            this.setIconBaseWithExtension(iconBase);
            super.setName(ProjectUtils.getInformation((Project)AbstractLogicalViewProvider.this.project).getDisplayName());
            AbstractLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)AbstractLogicalViewProvider.this));
            AbstractLogicalViewProvider.this.testBroken();
        }

        public String getShortDescription() {
            String prjDirDispName = FileUtil.getFileDisplayName((FileObject)AbstractLogicalViewProvider.this.project.getProjectDirectory());
            return MessageFormat.format(this.shortDesc, prjDirDispName);
        }

        public Image getIcon(int type) {
            Image original = super.getIcon(type);
            if (this.isBroken()) {
                return ImageUtilities.mergeImages((Image)original, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (AbstractLogicalViewProvider.this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave(original);
            }
            return original;
        }

        public Image getOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            if (this.isBroken()) {
                return ImageUtilities.mergeImages((Image)original, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (AbstractLogicalViewProvider.this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave(original);
            }
            return original;
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return this.isBroken() ? "<font color=\"#A40000\">" + dispName + "</font>" : null;
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)this.actionsFolderLayer);
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)AbstractLogicalViewProvider.this.project, (String)s);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.helpContext);
        }

        private boolean isBroken() {
            return AbstractLogicalViewProvider.this.broken || AbstractLogicalViewProvider.this.brokenServer || AbstractLogicalViewProvider.this.brokenDataSource || AbstractLogicalViewProvider.this.brokenServerLibrary;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }
    }
}

