/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.displayer;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;

public final class JavaVariablesDisplayer
implements VariableDisplayer {
    private static final String HUB = "__hub__";
    private static final String ARRAY = "__array__";
    private static final String ARRAY_LENGTH = "__length__";
    private static final String COMPRESSED_REF_REFIX = "_z_.";
    private static final String PUBLIC = "public";
    private static final String STRING_VALUE = "value";
    private static final String STRING_CODER = "coder";
    private static final String HASH = "hash";
    private static final String UNSET = "<optimized out>";
    private static final String[] STRING_TYPES = new String[]{String.class.getName(), StringBuilder.class.getName(), StringBuffer.class.getName()};
    private NIDebugger debugger;

    public void setDebugger(NIDebugger debugger) {
        this.debugger = debugger;
    }

    public NIVariable[] displayed(NIVariable[] variables) {
        ArrayList<NIVariable> displayedVars = new ArrayList<NIVariable>(variables.length);
        for (NIVariable var : variables) {
            Object displayedVar;
            String value = var.getValue();
            if (UNSET.equals(value)) continue;
            int nch = var.getNumChildren();
            if (nch == 0) {
                String name = var.getName();
                displayedVar = !name.equals(JavaVariablesDisplayer.getNameOrIndex(name)) ? new Var(var) : var;
            } else {
                NIVariable[] children = var.getChildren();
                NIVariable[] subChildren = children[0].getChildren();
                if (subChildren.length == 3 && ARRAY_LENGTH.equals(subChildren[1].getName()) && ARRAY.equals(subChildren[2].getName())) {
                    displayedVar = new ArrayVar(var, subChildren[1], subChildren[2]);
                } else {
                    String name;
                    String type = JavaVariablesDisplayer.getSimpleType(var.getType());
                    boolean isString = STRING_TYPES[0].equals(type);
                    boolean likeString = isString;
                    if (!likeString) {
                        for (String strType : STRING_TYPES) {
                            if (!strType.equals(type)) continue;
                            likeString = true;
                            break;
                        }
                    }
                    displayedVar = likeString ? new StringVar(var, type, isString ? null : subChildren) : (children.length == 1 && PUBLIC.equals(children[0].getName()) ? new ObjectVar(var, subChildren) : (!(name = var.getName()).equals(JavaVariablesDisplayer.getNameOrIndex(name)) ? new Var(var) : var));
                }
            }
            displayedVars.add((NIVariable)displayedVar);
        }
        return displayedVars.toArray(new NIVariable[displayedVars.size()]);
    }

    private static String displayType(String type) {
        if (type.startsWith(COMPRESSED_REF_REFIX)) {
            type = type.substring(COMPRESSED_REF_REFIX.length());
        }
        if (type.endsWith("*")) {
            type = type.substring(0, type.length() - 1).trim();
        }
        return type;
    }

    private static String getSimpleType(String type) {
        type = JavaVariablesDisplayer.displayType(type);
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return type.substring(0, i);
        }
        return type;
    }

    private static boolean isOfType(String varType, String type) {
        return (varType = JavaVariablesDisplayer.displayType(varType)).equals(type) || varType.startsWith(type) && !Character.isJavaIdentifierPart(varType.charAt(type.length()));
    }

    private static int getTypeSize(String type) {
        switch (type = JavaVariablesDisplayer.getSimpleType(type)) {
            case "boolean": 
            case "byte": {
                return 1;
            }
            case "char": 
            case "short": {
                return 2;
            }
            case "int": 
            case "float": {
                return 4;
            }
            case "long": 
            case "double": {
                return 8;
            }
        }
        return 8;
    }

    private static Map<String, NIVariable> getVarsByName(NIVariable[] vars) {
        switch (vars.length) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(vars[0].getName(), vars[0]);
            }
        }
        HashMap<String, NIVariable> varsByName = new HashMap<String, NIVariable>(vars.length);
        for (NIVariable var : vars) {
            varsByName.put(var.getName(), var);
        }
        return varsByName;
    }

    private static NIVariable[] restrictChildren(NIVariable[] children, int from, int to) {
        if (from > 0 || to < children.length) {
            children = from < (to = Math.min(to, children.length)) ? Arrays.copyOfRange(children, from, to) : new NIVariable[]{};
        }
        return children;
    }

    private static String getHash(NIVariable[] children) {
        for (NIVariable child : children) {
            if (!HASH.equals(child.getName())) continue;
            String hash = child.getValue();
            try {
                hash = Integer.toHexString(Integer.parseInt(hash));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return hash;
        }
        return null;
    }

    private static String getArrayExpression(NIVariable variable) {
        StringBuilder arrayExpression = new StringBuilder(variable.getName());
        while ((variable = variable.getParent()) != null) {
            if (PUBLIC.equals(variable.getName())) continue;
            arrayExpression.insert(0, '.');
            arrayExpression.insert(0, variable.getName());
        }
        return arrayExpression.toString();
    }

    private static String getNameOrIndex(String name) {
        int i;
        if (name.endsWith("]") && (i = name.lastIndexOf("__array__[")) > 0) {
            String index = name.substring(i + ARRAY.length() + 1, name.length() - 1);
            return index;
        }
        return name;
    }

    private String readArray(NIVariable lengthVariable, int itemSize) {
        int length = Integer.parseInt(lengthVariable.getValue());
        String expressionPath = lengthVariable.getExpressionPath();
        if (expressionPath != null && !expressionPath.isEmpty()) {
            String addressExpr = "&" + expressionPath;
            return this.debugger.readMemory(addressExpr, 4L, length * itemSize);
        }
        return null;
    }

    private String readArray(NIVariable lengthVariable, int offset, int itemSize) {
        int length = Integer.parseInt(lengthVariable.getValue());
        String expressionPath = lengthVariable.getExpressionPath();
        if (expressionPath != null && !expressionPath.isEmpty()) {
            String addressExpr = "&" + expressionPath;
            return this.debugger.readMemory(addressExpr, (long)(4 + offset), length * itemSize);
        }
        return null;
    }

    private static NIVariable[] getObjectChildren(NIVariable[] children, int from, int to) {
        for (int i = 0; i < children.length; ++i) {
            if (!HUB.equals(children[i].getName())) continue;
            NIVariable[] ch1 = Arrays.copyOf(children, i);
            NIVariable[] ch2 = Arrays.copyOfRange(children, i + 1, children.length);
            if (ch1.length == 0) {
                return ch2;
            }
            if (ch2.length == 0) {
                return ch1;
            }
            NIVariable[] ch = new NIVariable[ch1.length + ch2.length];
            System.arraycopy(ch1, 0, ch, 0, ch1.length);
            System.arraycopy(ch2, 0, ch, ch1.length, ch2.length);
            return ch;
        }
        return JavaVariablesDisplayer.restrictChildren(children, from, to);
    }

    private class Var
    implements NIVariable {
        private final NIVariable var;

        Var(NIVariable var) {
            this.var = var;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getName() {
            return JavaVariablesDisplayer.getNameOrIndex(this.var.getName());
        }

        public String getType() {
            return this.var.getType();
        }

        public String getValue() {
            return this.var.getValue();
        }

        public int getNumChildren() {
            return this.var.getNumChildren();
        }

        public NIVariable[] getChildren(int from, int to) {
            return this.var.getChildren(from, to);
        }

        public NIVariable[] getChildren() {
            return this.var.getChildren();
        }

        public String getExpressionPath() {
            return this.var.getExpressionPath();
        }
    }

    private class ObjectVar
    implements NIVariable {
        private final NIVariable var;
        private final NIVariable[] children;

        ObjectVar(NIVariable var, NIVariable[] children) {
            this.var = var;
            this.children = children;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getName() {
            return JavaVariablesDisplayer.getNameOrIndex(this.var.getName());
        }

        public String getType() {
            return JavaVariablesDisplayer.displayType(this.var.getType());
        }

        public String getValue() {
            String value = this.var.getValue();
            if (value.startsWith("@") || value.startsWith("0x")) {
                String hash = JavaVariablesDisplayer.getHash(this.children);
                if (hash == null) {
                    hash = value.startsWith("@") ? value.substring(1) : value.substring(2);
                }
                value = this.getType() + '@' + hash;
            }
            return value;
        }

        public int getNumChildren() {
            return this.children.length;
        }

        public NIVariable[] getChildren(int from, int to) {
            return JavaVariablesDisplayer.getObjectChildren(this.children, from, to);
        }

        public String getExpressionPath() {
            return this.var.getExpressionPath();
        }
    }

    private class ArrayVar
    implements NIVariable {
        private final NIVariable var;
        private final NIVariable lengthVariable;
        private final int length;
        private final NIVariable array;

        ArrayVar(NIVariable var, NIVariable lengthVariable, NIVariable array) {
            int arrayLength;
            this.var = var;
            this.lengthVariable = lengthVariable;
            try {
                arrayLength = Integer.parseInt(lengthVariable.getValue());
            }
            catch (NumberFormatException ex) {
                arrayLength = 0;
            }
            this.length = arrayLength;
            this.array = array;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getName() {
            return JavaVariablesDisplayer.getNameOrIndex(this.var.getName());
        }

        public String getType() {
            return JavaVariablesDisplayer.displayType(this.var.getType());
        }

        public String getValue() {
            String value = this.var.getValue();
            if (value.startsWith("@")) {
                value = this.getType() + value;
            }
            return value + "(length=" + this.length + ")";
        }

        public int getNumChildren() {
            return this.length;
        }

        public NIVariable[] getChildren(int from, int to) {
            if (from >= 0) {
                to = Math.min(to, this.length);
            } else {
                from = 0;
                to = this.length;
            }
            if (from >= to) {
                return new NIVariable[0];
            }
            String arrayAddress = null;
            String expressionPath = this.lengthVariable.getExpressionPath();
            if (expressionPath != null && !expressionPath.isEmpty()) {
                NIVariable addressVariable;
                String addressExpr = "&" + expressionPath;
                try {
                    addressVariable = JavaVariablesDisplayer.this.debugger.evaluate(addressExpr, null, this.lengthVariable.getFrame());
                }
                catch (EvaluateException ex) {
                    addressVariable = null;
                }
                if (addressVariable != null) {
                    String address = addressVariable.getValue();
                    if ((address = address.toLowerCase()).startsWith("0x")) {
                        arrayAddress = address;
                    }
                }
            }
            NIVariable[] elements = new NIVariable[to - from];
            try {
                if (arrayAddress != null) {
                    String itemExpression = "*(" + JavaVariablesDisplayer.getSimpleType(this.getType()) + "*)(" + arrayAddress + "+";
                    int size = JavaVariablesDisplayer.getTypeSize(this.getType());
                    int offset = 4 + from * size;
                    for (int i = from; i < to; ++i) {
                        NIVariable element = JavaVariablesDisplayer.this.debugger.evaluate(itemExpression + offset + ")", Integer.toString(i), this.var.getFrame());
                        offset += size;
                        elements[i - from] = element;
                    }
                } else {
                    String arrayExpression = JavaVariablesDisplayer.getArrayExpression(this.array);
                    for (int i = from; i < to; ++i) {
                        NIVariable element;
                        elements[i - from] = element = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + i + "]", Integer.toString(i), this.var.getFrame());
                    }
                }
            }
            catch (EvaluateException ex) {
                return new NIVariable[0];
            }
            return elements;
        }

        public String getExpressionPath() {
            return this.var.getExpressionPath();
        }
    }

    private class StringVar
    implements NIVariable {
        private final NIVariable var;
        private final String type;
        private final NIVariable[] children;

        StringVar(NIVariable var, String type, NIVariable[] children) {
            this.var = var;
            this.type = type;
            this.children = children;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public String getName() {
            return JavaVariablesDisplayer.getNameOrIndex(this.var.getName());
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            String hexArray;
            NIVariable pub = (NIVariable)JavaVariablesDisplayer.getVarsByName(this.var.getChildren()).get(JavaVariablesDisplayer.PUBLIC);
            Map varChildren = JavaVariablesDisplayer.getVarsByName(pub.getChildren());
            Map arrayInfo = JavaVariablesDisplayer.getVarsByName(((NIVariable)varChildren.get(JavaVariablesDisplayer.STRING_VALUE)).getChildren());
            arrayInfo = JavaVariablesDisplayer.getVarsByName(((NIVariable)arrayInfo.get(JavaVariablesDisplayer.PUBLIC)).getChildren());
            NIVariable arrayVariable = (NIVariable)arrayInfo.get(JavaVariablesDisplayer.ARRAY);
            NIVariable lengthVariable = (NIVariable)arrayInfo.get(JavaVariablesDisplayer.ARRAY_LENGTH);
            int length = Integer.parseInt(lengthVariable.getValue());
            NIVariable coderVar = (NIVariable)varChildren.get(JavaVariablesDisplayer.STRING_CODER);
            int coder = -1;
            if (coderVar != null) {
                String coderStr = coderVar.getValue();
                int space = coderStr.indexOf(32);
                if (space > 0) {
                    coderStr = coderStr.substring(0, space);
                }
                try {
                    coder = Integer.parseInt(coderStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((hexArray = JavaVariablesDisplayer.this.readArray(lengthVariable, coder == -1 ? 4 : 0, 2)) != null) {
                switch (coder) {
                    case 0: {
                        return this.parseLatin1(hexArray, length);
                    }
                    case 1: {
                        return this.parseUTF16(hexArray, length / 2);
                    }
                }
                return this.parseUTF16(hexArray, length);
            }
            String arrayExpression = JavaVariablesDisplayer.getArrayExpression(arrayVariable);
            char[] characters = new char[length];
            try {
                for (int i = 0; i < length; ++i) {
                    NIVariable charVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + i + "]", null, this.var.getFrame());
                    characters[i] = charVar.getValue().charAt(1);
                }
            }
            catch (EvaluateException ex) {
                return ex.getLocalizedMessage();
            }
            return new String(characters);
        }

        private String parseUTF16(String hexArray, int length) {
            CharsetDecoder cd = Charset.forName("utf-16").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(2);
            char[] characters = new char[length];
            int ih = 0;
            for (int i = 0; i < length; ++i) {
                byte b1 = this.parseByte(hexArray, ih);
                byte b0 = this.parseByte(hexArray, ih += 2);
                ih += 2;
                buffer.rewind();
                buffer.put(b0);
                buffer.put(b1);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        private String parseLatin1(String hexArray, int length) {
            CharsetDecoder cd = Charset.forName("latin1").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(1);
            char[] characters = new char[length];
            int ih = 0;
            for (int i = 0; i < length; ++i) {
                byte b = this.parseByte(hexArray, ih);
                ih += 2;
                buffer.rewind();
                buffer.put(b);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        private byte parseByte(String hexArray, int offset) {
            String hex = new String(new char[]{hexArray.charAt(offset), hexArray.charAt(offset + 1)});
            return (byte)(Integer.parseInt(hex, 16) & 0xFF);
        }

        public int getNumChildren() {
            return this.children != null ? this.children.length : 0;
        }

        public NIVariable[] getChildren(int from, int to) {
            return this.children != null ? JavaVariablesDisplayer.getObjectChildren(this.children, from, to) : new NIVariable[]{};
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getExpressionPath() {
            return this.var.getExpressionPath();
        }
    }
}

