/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.j2semodule.J2SEModularProject;
import org.netbeans.modules.java.j2semodule.J2SEModularProjectUtil;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

final class CoSAwareFileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener {
    private final FileBuiltQueryImplementation delegate;
    private final J2SEModularProject project;
    private final AtomicBoolean cosEnabled = new AtomicBoolean();
    private final Map<FileObject, Reference<StatusImpl>> file2Status = new WeakHashMap<FileObject, Reference<StatusImpl>>();

    public CoSAwareFileBuiltQueryImpl(FileBuiltQueryImplementation delegate, J2SEModularProject project) {
        this.delegate = delegate;
        this.project = project;
        project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        this.setCoSEnabledAndXor();
    }

    private synchronized StatusImpl readFromCache(FileObject file) {
        Reference<StatusImpl> r = this.file2Status.get(file);
        return r != null ? r.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBuiltQuery.Status getStatus(FileObject file) {
        StatusImpl result = this.readFromCache(file);
        if (result != null) {
            return result;
        }
        FileBuiltQuery.Status status = this.delegate.getStatus(file);
        if (status == null) {
            return null;
        }
        CoSAwareFileBuiltQueryImpl coSAwareFileBuiltQueryImpl = this;
        synchronized (coSAwareFileBuiltQueryImpl) {
            StatusImpl foisted = this.readFromCache(file);
            if (foisted != null) {
                return foisted;
            }
            result = new StatusImpl(this.cosEnabled, status);
            this.file2Status.put(file, new WeakReference<StatusImpl>(result));
        }
        return result;
    }

    boolean setCoSEnabledAndXor() {
        boolean nue = J2SEModularProjectUtil.isCompileOnSaveEnabled(this.project);
        boolean old = this.cosEnabled.getAndSet(nue);
        return old != nue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LinkedList<Reference<StatusImpl>> toRefresh;
        if (!this.setCoSEnabledAndXor()) {
            return;
        }
        CoSAwareFileBuiltQueryImpl coSAwareFileBuiltQueryImpl = this;
        synchronized (coSAwareFileBuiltQueryImpl) {
            toRefresh = new LinkedList<Reference<StatusImpl>>(this.file2Status.values());
        }
        for (Reference reference : toRefresh) {
            StatusImpl s = (StatusImpl)reference.get();
            if (s == null) continue;
            s.stateChanged(null);
        }
    }

    private static final class StatusImpl
    implements FileBuiltQuery.Status,
    ChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final AtomicBoolean cosEnabled;
        private final FileBuiltQuery.Status delegate;

        public StatusImpl(AtomicBoolean cosEnabled, FileBuiltQuery.Status delegate) {
            this.cosEnabled = cosEnabled;
            this.delegate = delegate;
            this.delegate.addChangeListener((ChangeListener)this);
        }

        public boolean isBuilt() {
            return this.cosEnabled.get() || this.delegate.isBuilt();
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }
}

