/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2sedeploy.Bundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public enum NativeBundleType {
    ALL("native-bundle-all", "all", Bundle.TXT_All(), OS.values()),
    ALL_INSTALLERS("native-bundle-all-installers", "installer", Bundle.TXT_AllInstallers(), OS.values()),
    IMAGE("native-bundle-image", "image", Bundle.TXT_Image(), OS.values()),
    DMG("native-bundle-dmg-installer", "dmg", Bundle.TXT_DMGImage(), OS.OSX),
    EXE("native-bundle-exe-installer", "exe", Bundle.TXT_EXEInstaller(), OS.WINDOWS),
    MSI("native-bundle-msi-installer", "msi", Bundle.TXT_MSIInstaller(), OS.WINDOWS),
    DEB("native-bundle-deb-installer", "deb", Bundle.TXT_DEBPackage(), OS.LINUX),
    RPM("native-bundle-rpm-installer", "rpm", Bundle.TXT_RPMPackage(), OS.LINUX);

    private static final Map<String, NativeBundleType> commandToBundleType;
    private final String command;
    private final String antPropValue;
    private final String displayName;
    private final Set<OS> systems;

    private NativeBundleType(@NonNull String command, @NonNull String antPropValue, String displayName, OS ... systems) {
        Parameters.notNull((CharSequence)"command", (Object)command);
        Parameters.notNull((CharSequence)"antPropValue", (Object)antPropValue);
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        Parameters.notNull((CharSequence)"systems", (Object)systems);
        this.command = command;
        this.antPropValue = antPropValue;
        this.displayName = displayName;
        this.systems = EnumSet.noneOf(OS.class);
        Collections.addAll(this.systems, systems);
    }

    @NonNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NonNull
    public String getCommand() {
        return this.command;
    }

    @NonNull
    public String getAntProperyValue() {
        return this.antPropValue;
    }

    public boolean isSupported() {
        for (OS os : this.systems) {
            if (!os.isCurrent()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static Set<NativeBundleType> getSupported() {
        EnumSet<NativeBundleType> res = EnumSet.noneOf(NativeBundleType.class);
        for (NativeBundleType nbt : NativeBundleType.values()) {
            if (!nbt.isSupported()) continue;
            res.add(nbt);
        }
        return Collections.unmodifiableSet(res);
    }

    @CheckForNull
    public static NativeBundleType forCommand(@NonNull String command) {
        Parameters.notNull((CharSequence)"command", (Object)command);
        return commandToBundleType.get(command);
    }

    static {
        HashMap<String, NativeBundleType> m = new HashMap<String, NativeBundleType>();
        for (NativeBundleType nbt : NativeBundleType.values()) {
            m.put(nbt.getCommand(), nbt);
        }
        commandToBundleType = Collections.unmodifiableMap(m);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum OS {
        OSX{

            @Override
            boolean isCurrent() {
                return Utilities.isMac();
            }
        }
        ,
        LINUX{

            @Override
            boolean isCurrent() {
                return Utilities.getOperatingSystem() == 16;
            }
        }
        ,
        WINDOWS{

            @Override
            boolean isCurrent() {
                return Utilities.isWindows();
            }
        };


        abstract boolean isCurrent();
    }
}

