/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2sedeploy.NativeBundleType;
import org.netbeans.modules.java.j2sedeploy.ui.Bundle;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.actions.Presenter;

public final class CreateBundleAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private final ActionProvider actionProvider;
    private final Lookup context;

    public CreateBundleAction() {
        this.actionProvider = null;
        this.context = null;
        this.init();
        this.setEnabled(false);
    }

    private CreateBundleAction(@NonNull ActionProvider actionProvider, @NonNull Lookup context) {
        Parameters.notNull((CharSequence)"actionProvider", (Object)actionProvider);
        Parameters.notNull((CharSequence)"context", (Object)context);
        this.actionProvider = actionProvider;
        this.context = context;
        this.init();
    }

    private void init() {
        this.putValue("Name", Bundle.CTL_CreateBundleAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putValue("hideWhenDisabled", true);
    }

    @Override
    public void actionPerformed(@NonNull ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Project project = (Project)actionContext.lookup(Project.class);
        if (project == null) {
            return this;
        }
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        return !CreateBundleAction.supportsImages(ap, actionContext) ? this : new CreateBundleAction(ap, actionContext);
    }

    public JMenuItem getPopupPresenter() {
        JMenu m = new JMenu(this);
        m.putClientProperty("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        if (this.actionProvider != null) {
            assert (this.context != null);
            for (NativeBundleType nbt : NativeBundleType.getSupported()) {
                m.add(new JMenuItem(new PackageAction(nbt, this.actionProvider, this.context)));
            }
        }
        return m;
    }

    private static boolean supportsImages(@NullAllowed ActionProvider ap, @NonNull Lookup ctx) {
        if (ap == null) {
            return false;
        }
        String found = null;
        for (String action : ap.getSupportedActions()) {
            if (NativeBundleType.forCommand(action) == null) continue;
            found = action;
            break;
        }
        if (found == null) {
            return false;
        }
        return ap.isActionEnabled(found, ctx);
    }

    private final class PackageAction
    extends AbstractAction {
        private final ActionProvider ap;
        private final String command;
        private final Lookup context;

        PackageAction(@NonNull NativeBundleType nativeBundleType, @NonNull ActionProvider ap, Lookup context) {
            Parameters.notNull((CharSequence)"nativeBundleType", (Object)((Object)nativeBundleType));
            Parameters.notNull((CharSequence)"ap", (Object)ap);
            Parameters.notNull((CharSequence)"context", (Object)context);
            this.putValue("Name", nativeBundleType.getDisplayName());
            this.ap = ap;
            this.command = nativeBundleType.getCommand();
            this.context = context;
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            if (this.ap.isActionEnabled(this.command, this.context)) {
                this.ap.invokeAction(this.command, this.context);
            }
        }
    }
}

