/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.netbeans.modules.java.hints.infrastructure.HintAction;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.introduce.MethodCandidateChooser;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class IntroduceAction
extends HintAction {
    private final IntroduceKind type;
    private static final String MENU_TEXT = "menuText";
    private static final String POPUP_TEXT = "popupText";

    private IntroduceAction(IntroduceKind type) {
        super(type.getKey());
        this.type = type;
        switch (type) {
            case CREATE_CONSTANT: {
                this.putValue("Name", type.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                break;
            }
            case CREATE_VARIABLE: {
                this.putValue("Name", type.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                break;
            }
            case CREATE_FIELD: {
                this.putValue("Name", type.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                break;
            }
            case CREATE_METHOD: {
                this.putValue("Name", type.getKey());
                this.putValue("ShortDescription", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
                this.putValue(MENU_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
                this.putValue(POPUP_TEXT, NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
            }
        }
        this.setEnabled(true);
    }

    @Override
    protected void perform(JavaSource js, JTextComponent pane, int[] selection) {
        String error = this.doPerformAction(js, pane, selection);
        if (error != null) {
            String errorText = NbBundle.getMessage(IntroduceAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerformAction(final JavaSource js, JTextComponent pane, final int[] span) {
        Fix fix;
        final ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        final AtomicBoolean cancel = new AtomicBoolean();
        final String[] errorMessage = new String[1];
        final boolean proposeCandidates = span[0] == span[1] && this.type != IntroduceKind.CREATE_METHOD;
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.RESOLVED);
                            if (cancel.get()) {
                                return;
                            }
                            if (proposeCandidates) {
                                TreePath tp = IntroduceAction.pathFor((CompilationInfo)parameter, span[0]);
                                Set seenTrees = Collections.newSetFromMap(new IdentityHashMap());
                                while (tp != null) {
                                    TreePath currentPath = tp;
                                    tp = tp.getParentPath();
                                    if (currentPath.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                                        currentPath = new TreePath(currentPath, ((ParenthesizedTree)currentPath.getLeaf()).getExpression());
                                    }
                                    if (!seenTrees.add(currentPath.getLeaf())) continue;
                                    EnumMap<IntroduceKind, Fix> fixes = new EnumMap<IntroduceKind, Fix>(IntroduceKind.class);
                                    EnumMap<IntroduceKind, String> errorMessages = new EnumMap<IntroduceKind, String>(IntroduceKind.class);
                                    int start = (int)parameter.getTrees().getSourcePositions().getStartPosition(parameter.getCompilationUnit(), currentPath.getLeaf());
                                    int end = (int)parameter.getTrees().getSourcePositions().getEndPosition(parameter.getCompilationUnit(), currentPath.getLeaf());
                                    if (end <= start || start == -1) continue;
                                    IntroduceHint.computeError((CompilationInfo)parameter, start, end, fixes, errorMessages, cancel);
                                    Fix f = (Fix)fixes.get((Object)IntroduceAction.this.type);
                                    if (f == null) continue;
                                    candidates.add(new Candidate(parameter.getText().substring(start, end), start, end, f));
                                }
                            } else {
                                EnumMap<IntroduceKind, Fix> fixes = new EnumMap<IntroduceKind, Fix>(IntroduceKind.class);
                                EnumMap<IntroduceKind, String> errorMessages = new EnumMap<IntroduceKind, String>(IntroduceKind.class);
                                IntroduceHint.computeError((CompilationInfo)parameter, span[0], span[1], fixes, errorMessages, cancel);
                                Fix f = (Fix)fixes.get((Object)IntroduceAction.this.type);
                                if (f != null) {
                                    candidates.add(new Candidate(null, -1, -1, f));
                                } else {
                                    errorMessage[0] = (String)errorMessages.get((Object)IntroduceAction.this.type);
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, (String)NbBundle.getMessage(IntroduceAction.class, (String)"LBL_Indroduce_Action"), (AtomicBoolean)cancel, (boolean)false);
        if (cancel.get()) {
            return null;
        }
        if (proposeCandidates) {
            if (!candidates.isEmpty()) {
                Point l = new Point(-1, -1);
                try {
                    Rectangle pos = pane.modelToView(pane.getCaretPosition());
                    l = new Point(pos.x + pos.width, pos.y + pos.height);
                    SwingUtilities.convertPointToScreen(l, pane);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                String label = NbBundle.getMessage(IntroduceAction.class, (String)"LBL_PickExpression");
                PopupUtil.showPopup((JComponent)new MethodCandidateChooser(label, candidates, pane.getDocument()), (String)label, (int)l.x, (int)l.y, (boolean)true, (int)-1);
                return null;
            }
            return "ERR_No_Valid_Expressions_Found";
        }
        Fix fix2 = fix = candidates.isEmpty() ? null : ((Candidate)candidates.get((int)0)).fix;
        if (fix != null) {
            try {
                fix.implement();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        if (errorMessage[0] != null) {
            return errorMessage[0];
        }
        return "ERR_Invalid_Selection";
    }

    @Override
    protected boolean requiresSelection() {
        return false;
    }

    private static TreePath pathFor(CompilationInfo info, int pos) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(info.getSnapshot().getEmbeddedOffset(pos));
        if (ts.moveNext() && ts.token().id() == JavaTokenId.IDENTIFIER) {
            pos = ts.offset() + 1;
        }
        return info.getTreeUtilities().pathFor(pos);
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(IntroduceKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(IntroduceKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(IntroduceKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(IntroduceKind.CREATE_METHOD);
    }

    public static Object createVariableGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"), IntroduceKind.CREATE_VARIABLE.getKey());
    }

    public static Object createConstantGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"), IntroduceKind.CREATE_CONSTANT.getKey());
    }

    public static Object createFieldGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"), IntroduceKind.CREATE_FIELD.getKey());
    }

    public static Object createMethodGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"), IntroduceKind.CREATE_METHOD.getKey());
    }

    static final class Candidate {
        final String displayName;
        final int start;
        final int end;
        final Fix fix;

        Candidate(String displayName, int start, int end, Fix fix) {
            this.displayName = displayName;
            this.start = start;
            this.end = end;
            this.fix = fix;
        }
    }

    private static final class GlobalActionImpl
    extends MainMenuAction
    implements Presenter.Popup {
        private final String menuItemText;
        private final String actionName;

        public GlobalActionImpl(String menu, String action) {
            this.menuItemText = menu;
            this.actionName = action;
            this.setMenu();
        }

        protected String getMenuItemText() {
            return this.menuItemText;
        }

        protected String getActionName() {
            return this.actionName;
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuPresenter();
        }
    }
}

