/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class StringBufferCharConstructor {
    public static ErrorDescription run(HintContext ctx) {
        TreePath p = ctx.getPath();
        TypeMirror paramType = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$x"));
        if (paramType.getKind() != TypeKind.CHAR) {
            if (paramType.getKind() != TypeKind.DECLARED) {
                return null;
            }
            Element el = ((DeclaredType)paramType).asElement();
            if (el == null || el.getKind() != ElementKind.CLASS) {
                return null;
            }
            if (!((TypeElement)el).getQualifiedName().contentEquals("java.lang.Character")) {
                return null;
            }
        }
        TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(p);
        CharSequence tname = ctx.getInfo().getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]);
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)p, (String)Bundle.TEXT_StringBufferCharConstructor(tname), (Fix[])new Fix[]{new NewAndAppendFix(TreePathHandle.create((TreePath)p, (CompilationInfo)ctx.getInfo()), tname.toString()).toEditorFix()});
    }

    private static class NewAndAppendFix
    extends JavaFix {
        final String builder;

        public NewAndAppendFix(TreePathHandle handle, String builder) {
            super(handle);
            this.builder = builder;
        }

        protected String getText() {
            return Bundle.FIX_StringBufferCharConstructor(this.builder);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath p = ctx.getPath();
            if (p.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            NewClassTree origNct = (NewClassTree)p.getLeaf();
            if (origNct.getArguments().size() != 1) {
                return;
            }
            NewClassTree nct = (NewClassTree)GeneratorUtilities.get((WorkingCopy)ctx.getWorkingCopy()).importComments((Tree)origNct, ctx.getWorkingCopy().getCompilationUnit());
            ExpressionTree charArg = nct.getArguments().get(0);
            TreeMaker mk = ctx.getWorkingCopy().getTreeMaker();
            NewClassTree newExpr = mk.NewClass(nct.getEnclosingExpression(), nct.getTypeArguments(), nct.getIdentifier(), Collections.emptyList(), nct.getClassBody());
            MethodInvocationTree replace = mk.MethodInvocation(Collections.emptyList(), (ExpressionTree)mk.MemberSelect((ExpressionTree)newExpr, (CharSequence)"append"), Collections.singletonList(charArg));
            ctx.getWorkingCopy().rewrite((Tree)nct, (Tree)replace);
        }
    }
}

