/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class EqualsMethodHint {
    public static ErrorDescription run(HintContext ctx) {
        TreePath paramPath = (TreePath)ctx.getVariables().get("$param");
        assert (paramPath != null);
        Element param = ctx.getInfo().getTrees().getElement(paramPath);
        if (param == null || param.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        for (TreePath st : (Collection)ctx.getMultiVariables().get("$statements$")) {
            try {
                new VisitorImpl(ctx.getInfo(), param).scan(st, null);
            }
            catch (Found f) {
                return null;
            }
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(EqualsMethodHint.class, (String)"ERR_EQUALS_NOT_CHECKING_TYPE"), (Fix[])new Fix[0]);
    }

    private static final class VisitorImpl
    extends ErrorAwareTreePathScanner<Void, Void> {
        private CompilationInfo info;
        private Element parameter;

        public VisitorImpl(CompilationInfo info, Element parameter) {
            this.info = info;
            this.parameter = parameter;
        }

        public Void visitInstanceOf(InstanceOfTree node, Void p) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (this.parameter.equals(e)) {
                throw new Found();
            }
            return (Void)super.visitInstanceOf(node, (Object)p);
        }

        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (node.getArguments().isEmpty()) {
                IdentifierTree it;
                if (node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                    MemberSelectTree mst = (MemberSelectTree)node.getMethodSelect();
                    Element e = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), mst), mst.getExpression()));
                    if (this.parameter.equals(e) && mst.getIdentifier().contentEquals("getClass")) {
                        throw new Found();
                    }
                } else if (node.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && (it = (IdentifierTree)node.getMethodSelect()).getName().contentEquals("getClass")) {
                    throw new Found();
                }
            }
            return (Void)super.visitMethodInvocation(node, (Object)p);
        }
    }

    private static final class Found
    extends RuntimeException {
        private Found() {
        }
    }
}

