/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.completion.Utilities;
import org.netbeans.modules.java.editor.base.imports.UnusedImports;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class Imports {
    private static final String DEFAULT_PACKAGE = "java.lang";
    private String IMPORTS_ID = "Imports_";

    public static ErrorDescription starImport(HintContext ctx) {
        ImportTree it = (ImportTree)ctx.getPath().getLeaf();
        if (it.isStatic() || !(it.getQualifiedIdentifier() instanceof MemberSelectTree)) {
            return null;
        }
        MemberSelectTree ms = (MemberSelectTree)it.getQualifiedIdentifier();
        if (!"*".equals(ms.getIdentifier().toString())) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(Imports.class, (String)"DN_Imports_STAR"), (Fix[])new Fix[0]);
    }

    public static List<ErrorDescription> defaultImport(HintContext ctx) {
        return Imports.importMultiHint(ctx, ImportHintKind.DEFAULT_PACKAGE, Imports.getAllImportsOfKind(ctx.getInfo(), ImportHintKind.DEFAULT_PACKAGE));
    }

    public static List<ErrorDescription> unusedImport(HintContext ctx) throws IOException {
        return Imports.importMultiHint(ctx, ImportHintKind.UNUSED, UnusedImports.computeUnusedImports((CompilationInfo)ctx.getInfo()));
    }

    public static List<ErrorDescription> samePackage(HintContext ctx) throws IOException {
        return Imports.importMultiHint(ctx, ImportHintKind.SAME_PACKAGE, Imports.getAllImportsOfKind(ctx.getInfo(), ImportHintKind.SAME_PACKAGE));
    }

    private static List<ErrorDescription> importMultiHint(HintContext ctx, ImportHintKind kind, List<TreePathHandle> violatingImports) {
        Fix allFix = null;
        if (ctx.isBulkMode() && !violatingImports.isEmpty()) {
            Fix af = new ImportsFix(violatingImports, kind).toEditorFix();
            TreePath tp = ctx.getPath();
            long pos = Integer.MAX_VALUE;
            for (TreePathHandle h : violatingImports) {
                TreePath currentPath = h.resolve(ctx.getInfo());
                assert (currentPath != null);
                long currentPos = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(currentPath.getCompilationUnit(), currentPath.getLeaf());
                if (currentPos >= pos) continue;
                tp = currentPath;
                pos = currentPos;
            }
            return Collections.singletonList(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)tp, (String)NbBundle.getMessage(Imports.class, (String)("DN_Imports_" + kind.toString() + "_Multi"), (Object)violatingImports.size()), (Fix[])new Fix[]{af}));
        }
        if (violatingImports.size() > 1) {
            allFix = new ImportsFix(violatingImports, kind).toEditorFix();
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(violatingImports.size());
        for (TreePathHandle it : violatingImports) {
            TreePath resolvedIt = it.resolve(ctx.getInfo());
            if (resolvedIt == null) continue;
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            fixes.add(new ImportsFix(Collections.singletonList(it), kind).toEditorFix());
            if (allFix != null) {
                fixes.add(allFix);
            }
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)resolvedIt, (String)NbBundle.getMessage(Imports.class, (String)("DN_Imports_" + kind.toString())), (Fix[])fixes.toArray(new Fix[0])));
        }
        return result;
    }

    public static ErrorDescription exlucded(HintContext ctx) throws IOException {
        ImportTree it = (ImportTree)ctx.getPath().getLeaf();
        if (it.isStatic() || !(it.getQualifiedIdentifier() instanceof MemberSelectTree)) {
            return null;
        }
        MemberSelectTree ms = (MemberSelectTree)it.getQualifiedIdentifier();
        String pkg = ms.getExpression().toString();
        String klass = ms.getIdentifier().toString();
        String exp = pkg + "." + (!klass.equals("*") ? klass : "");
        if (Utilities.isExcluded((CharSequence)exp)) {
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(Imports.class, (String)"DN_Imports_EXCLUDED"), (Fix[])new Fix[0]);
        }
        return null;
    }

    private static List<TreePathHandle> getAllImportsOfKind(CompilationInfo ci, ImportHintKind kind) {
        assert (kind == ImportHintKind.DEFAULT_PACKAGE || kind == ImportHintKind.SAME_PACKAGE);
        CompilationUnitTree cut = ci.getCompilationUnit();
        TreePath topLevel = new TreePath(cut);
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>(3);
        List<? extends ImportTree> imports = cut.getImports();
        for (ImportTree importTree : imports) {
            ExpressionTree packageName;
            if (importTree.isStatic() || !(importTree.getQualifiedIdentifier() instanceof MemberSelectTree)) continue;
            MemberSelectTree ms = (MemberSelectTree)importTree.getQualifiedIdentifier();
            if (kind == ImportHintKind.DEFAULT_PACKAGE && ms.getExpression().toString().equals(DEFAULT_PACKAGE)) {
                result.add(TreePathHandle.create((TreePath)new TreePath(topLevel, importTree), (CompilationInfo)ci));
            }
            if (kind != ImportHintKind.SAME_PACKAGE || (packageName = cut.getPackageName()) == null || !ms.getExpression().toString().equals(packageName.toString())) continue;
            result.add(TreePathHandle.create((TreePath)new TreePath(topLevel, importTree), (CompilationInfo)ci));
        }
        return result;
    }

    private static class ImportsFix
    extends JavaFix {
        List<TreePathHandle> tphList;
        ImportHintKind ihk;

        public ImportsFix(List<TreePathHandle> tphList, ImportHintKind ihk) {
            super(tphList.get(0));
            this.tphList = tphList;
            this.ihk = ihk;
        }

        public String getText() {
            if (this.tphList.size() == 1) {
                return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_One_" + this.ihk.toString()));
            }
            return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_All_" + this.ihk.toString()));
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            CompilationUnitTree cut = copy.getCompilationUnit();
            TreeMaker make = copy.getTreeMaker();
            CompilationUnitTree newCut = cut;
            for (TreePathHandle tph : this.tphList) {
                TreePath path = tph.resolve((CompilationInfo)copy);
                if (path == null || !(path.getLeaf() instanceof ImportTree)) continue;
                newCut = make.removeCompUnitImport(newCut, (ImportTree)path.getLeaf());
            }
            copy.rewrite((Tree)cut, (Tree)newCut);
        }
    }

    private static enum ImportHintKind {
        DELEGATE,
        UNUSED,
        DUPLICATE,
        SAME_PACKAGE,
        DEFAULT_PACKAGE,
        EXCLUDED,
        STAR;


        boolean defaultOn() {
            switch (this) {
                case DELEGATE: 
                case EXCLUDED: 
                case SAME_PACKAGE: 
                case DEFAULT_PACKAGE: 
                case UNUSED: {
                    return true;
                }
            }
            return false;
        }
    }
}

