/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.idebinding;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsParser;
import org.netbeans.modules.java.hints.declarative.Utilities;
import org.netbeans.modules.java.hints.declarative.idebinding.ParserImpl;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HintsTask
extends ParserResultTask<Parser.Result> {
    private static final Set<TypeKind> VOID_LIKE = EnumSet.of(TypeKind.VOID, TypeKind.ERROR, TypeKind.OTHER);

    public void run(Parser.Result result, SchedulerEvent event) {
        DeclarativeHintsParser.Result res = ParserImpl.getResult(result);
        List<Object> errors = res != null ? HintsTask.computeErrors(res, result.getSnapshot().getText(), result.getSnapshot().getSource().getFileObject()) : Collections.emptyList();
        HintsController.setErrors((FileObject)result.getSnapshot().getSource().getFileObject(), (String)HintsTask.class.getName(), errors);
    }

    static List<ErrorDescription> computeErrors(final @NonNull DeclarativeHintsParser.Result res, final @NonNull CharSequence hintCode, final @NonNull FileObject file) {
        final LinkedList<ErrorDescription> errors = new LinkedList<ErrorDescription>();
        errors.addAll(res.errors);
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)file);
        try {
            FileObject scratch = FileUtil.createMemoryFileSystem().getRoot().createData("Scratch.java");
            JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{scratch}).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    String[] stringArray;
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    if (res.importsBlock != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = hintCode.subSequence(res.importsBlock[0], res.importsBlock[1]).toString();
                    } else {
                        stringArray = new String[]{};
                    }
                    String[] importsArray = stringArray;
                    for (DeclarativeHintsParser.HintTextDescription hd : res.hints) {
                        TypeMirror type;
                        String code = hintCode.subSequence(hd.textStart, hd.textEnd).toString();
                        LinkedList parsedErrors = new LinkedList();
                        Scope s = org.netbeans.modules.java.hints.spiimpl.Utilities.constructScope((CompilationInfo)parameter, (Map)HintsTask.conditions2Constraints((CompilationInfo)parameter, hd.conditions), Arrays.asList(importsArray));
                        Tree parsed = org.netbeans.modules.java.hints.spiimpl.Utilities.parseAndAttribute((CompilationInfo)parameter, (String)code, (Scope)s, parsedErrors);
                        for (Diagnostic d : parsedErrors) {
                            errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)d.getMessage(null), (FileObject)file, (int)((int)((long)hd.textStart + d.getStartPosition())), (int)((int)((long)hd.textStart + d.getEndPosition()))));
                        }
                        if (parsed == null || !ExpressionTree.class.isAssignableFrom(parsed.getKind().asInterface()) || (type = parameter.getTrees().getTypeMirror(new TreePath(new TreePath(parameter.getCompilationUnit()), parsed))) == null || VOID_LIKE.contains((Object)type.getKind())) continue;
                        for (DeclarativeHintsParser.FixTextDescription df : hd.fixes) {
                            String fixCode = hintCode.subSequence(df.fixSpan[0], df.fixSpan[1]).toString().trim();
                            if (!fixCode.isEmpty()) continue;
                            errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)NbBundle.getMessage(HintsTask.class, (String)"ERR_RemoveExpression"), (FileObject)file, (int)hd.textStart, (int)hd.textEnd));
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return errors;
    }

    private static Map<String, TypeMirror> conditions2Constraints(CompilationInfo info, List<Condition> conditions) {
        HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
        for (Map.Entry<String, String> e : Utilities.conditions2Constraints(conditions).entrySet()) {
            TypeMirror designedType = Hacks.parseFQNType((CompilationInfo)info, (String)e.getValue());
            if (designedType == null || designedType.getKind() == TypeKind.ERROR) continue;
            constraints.put(e.getKey(), designedType);
        }
        return constraints;
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new HintsTask());
        }
    }
}

