/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.event.DownloadEvt;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.util.PkgInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.SwingWorker2;
import org.netbeans.modules.java.disco.WizardState;
import org.netbeans.modules.java.disco.archive.JDKCommonsUnzip;
import org.netbeans.modules.java.disco.archive.UnarchiveUtils;
import org.netbeans.modules.java.disco.ioprovider.IOContainerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class DownloadPanel
extends JPanel {
    public static final String PROP_DOWNLOAD_FINISHED = "downloadFinished";
    private boolean downloadFinished;
    private File download;
    private final Client discoClient;
    private final WizardState state;
    private IOContainerPanel executionPanel;
    private String downloadFolder;
    private boolean initialLoad = false;
    private JPanel bottomPanel;
    private JPanel jPanel1;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    @UIEffect
    public static DownloadPanel create(WizardState state) {
        DownloadPanel d = new DownloadPanel(state);
        d.init();
        return d;
    }

    @UIEffect
    private DownloadPanel(WizardState state) {
        this.state = state;
        this.discoClient = Client.getInstance();
    }

    @UIEffect
    private void init() {
        this.setName("Download");
        this.initComponents();
        this.executionPanel = new IOContainerPanel();
    }

    @Override
    @UIEffect
    public void addNotify() {
        super.addNotify();
        if (this.initialLoad) {
            return;
        }
        this.initialLoad = true;
        this.discoClient.setOnEvt((EvtType<? extends Evt>)DownloadEvt.DOWNLOAD_STARTED, this::handleDownloadStarted);
        this.discoClient.setOnEvt((EvtType<? extends Evt>)DownloadEvt.DOWNLOAD_FINISHED, this::handleDownloadFinished);
        this.discoClient.setOnEvt((EvtType<? extends Evt>)DownloadEvt.DOWNLOAD_FAILED, this::handleDownloadFailed);
        this.discoClient.setOnEvt((EvtType<? extends Evt>)DownloadEvt.DOWNLOAD_PROGRESS, this::handleDownloadProgress);
        this.downloadButtonActionPerformed();
    }

    public @NonNull String getDefaultDownloadFolder() {
        File f = OS.getDefaultDownloadFolder();
        if (f == null) {
            return "";
        }
        return f.getAbsolutePath();
    }

    @UIEffect
    private void downloadBundle(File destinationFolder) {
        this.setStatus("Preparing...");
        SwingWorker2.submit(() -> {
            Pkg bundle = this.state.selection.get(this.discoClient);
            return this.discoClient.getPkgInfo(bundle.getEphemeralId(), bundle.getJavaVersion());
        }).then(pkgInfo -> {
            this.download = new File(destinationFolder, pkgInfo.getFileName());
            Future<?> future = this.discoClient.downloadPkg((PkgInfo)pkgInfo, this.download.getAbsolutePath());
        }).handle(this::handleDownloadFailed).execute();
    }

    @UIEffect
    private void setStatus(String text) {
        this.setStatus(text, null);
    }

    @UIEffect
    private void setStatus(String text, @Nullable String uiKey) {
        this.statusLabel.setText(text);
        if (uiKey != null) {
            this.statusLabel.setIcon(UIManager.getIcon(uiKey));
        } else {
            this.statusLabel.setIcon(null);
        }
        this.putClientProperty("WizardPanel_infoMessage", text);
    }

    private void handleDownloadStarted(Evt e) {
        SwingUtilities.invokeLater(() -> this.setStatus("Downloading..."));
    }

    private void handleDownloadFinished(Evt e) {
        this.downloadFinished = true;
        if (UnarchiveUtils.isArchiveFile(this.download)) {
            SwingUtilities.invokeLater(() -> {
                this.setStatus("Unarchiving...", "Menu.arrowIcon");
                this.bottomPanel.add(this.executionPanel);
                ((CardLayout)this.bottomPanel.getLayout()).last(this.bottomPanel);
                InputOutput io = IOProvider.getDefault().getIO("Unarchive output", new Action[0], IOContainer.create((IOContainer.Provider)this.executionPanel));
                SwingWorker2.submit(() -> this.unarchive(io)).then(file -> {
                    this.download = file;
                    this.notifyDownloadFinished();
                }).handle(Exceptions::printStackTrace).execute();
            });
        } else {
            SwingUtilities.invokeLater(this::notifyDownloadFinished);
        }
    }

    @UIEffect
    private void notifyDownloadFinished() {
        this.setStatus("Finished.");
        this.firePropertyChange(PROP_DOWNLOAD_FINISHED, false, true);
    }

    private void handleDownloadProgress(Evt e) {
        DownloadEvt event = (DownloadEvt)e;
        int percentage = (int)((double)event.getFraction() / (double)event.getFileSize() * 100.0);
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(percentage));
    }

    private void handleDownloadFailed(@Nullable Exception e) {
        if (e != null) {
            Exceptions.printStackTrace((Throwable)e);
        }
        SwingUtilities.invokeLater(() -> this.setStatus("Download failed", "OptionPane.warningIcon"));
    }

    private void handleDownloadFailed(Evt e) {
        this.handleDownloadFailed((Exception)null);
    }

    private File unarchive(InputOutput io) throws IOException, InterruptedException {
        File parent;
        File outputFile = UnarchiveUtils.unarchive(this.download, io);
        File binFolder = JDKCommonsUnzip.findBin(outputFile);
        if (binFolder != null && (parent = binFolder.getParentFile()) != null) {
            return parent;
        }
        return outputFile;
    }

    public boolean isDownloadFinished() {
        return this.downloadFinished;
    }

    public File getDownload() {
        return this.download;
    }

    @UIEffect
    private void initComponents() {
        this.statusLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(this.statusLabel.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.statusLabel.text"));
        this.bottomPanel.setLayout(new CardLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.progressBar.setStringPainted(true);
        this.jPanel1.add((Component)this.progressBar, "North");
        this.bottomPanel.add((Component)this.jPanel1, "card2");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addGap(119, 119, 119)).addGroup(layout.createSequentialGroup().addComponent(this.bottomPanel, -1, 289, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void downloadButtonActionPerformed() {
        this.progressBar.setValue(0);
        this.downloadBundle(new File(this.downloadFolder));
    }

    public void setDownloadFolder(String folder) {
        this.downloadFolder = folder;
    }
}

