/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.BasicAggregateProgressFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DatabaseTablesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EntityClassesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.MappingOptionsPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RelatedCMPWizard
implements TemplateWizard.Iterator {
    private static final String PROP_HELPER = "wizard-helper";
    private static final String TYPE_JPA = "jpa";
    private static final Lookup.Result<PersistenceGeneratorProvider> PERSISTENCE_PROVIDERS = Lookup.getDefault().lookupResult(PersistenceGeneratorProvider.class);
    private final String type;
    private WizardDescriptor.Panel[] panels;
    private int currentPanel = 0;
    private WizardDescriptor wizardDescriptor;
    private PersistenceGenerator generator;
    private RelatedCMPHelper helper;
    private ProgressPanel progressPanel;
    private Project project;
    private final RequestProcessor RP = new RequestProcessor(RelatedCMPWizard.class.getSimpleName(), 5);

    public static RelatedCMPWizard createForJPA() {
        return new RelatedCMPWizard(TYPE_JPA);
    }

    private static PersistenceGenerator createPersistenceGenerator(String type) {
        assert (type != null);
        Collection providers = PERSISTENCE_PROVIDERS.allInstances();
        for (PersistenceGeneratorProvider provider : providers) {
            if (!type.equals(provider.getGeneratorType())) continue;
            return provider.createGenerator();
        }
        throw new AssertionError((Object)("Could not find a persistence generator of type " + type));
    }

    static RelatedCMPHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (RelatedCMPHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    public RelatedCMPWizard(String type) {
        this.type = type;
    }

    public String name() {
        return null;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentPanel;
    }

    public boolean hasNext() {
        return this.currentPanel < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentPanel;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.currentPanel];
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        String wizardBundleKey = "Templates/Persistence/RelatedCMP";
        String wizardTitle = NbBundle.getMessage(RelatedCMPWizard.class, (String)wizardBundleKey);
        if (TYPE_JPA.equals(this.type)) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[3];
            panelArray2[0] = new DatabaseTablesPanel.WizardPanel(wizardTitle);
            panelArray2[1] = new EntityClassesPanel.WizardPanel();
            panelArray = panelArray2;
            panelArray2[2] = new MappingOptionsPanel.WizardPanel();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[2];
            panelArray3[0] = new DatabaseTablesPanel.WizardPanel(null);
            panelArray = panelArray3;
            panelArray3[1] = new EntityClassesPanel.WizardPanel(false, false, true, false);
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        if (TYPE_JPA.equals(this.type)) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_DatabaseTables");
            stringArray2[1] = NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_EntityClasses");
            stringArray = stringArray2;
            stringArray2[2] = NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_MappingOptions");
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_DatabaseTables");
            stringArray = stringArray3;
            stringArray3[1] = NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_EntityClasses");
        }
        return stringArray;
    }

    public final void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels();
        Wizards.mergeSteps((WizardDescriptor)this.wizardDescriptor, (WizardDescriptor.Panel[])this.panels, (String[])this.createSteps());
        this.generator = RelatedCMPWizard.createPersistenceGenerator(this.type);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        FileObject configFilesFolder = PersistenceLocation.getLocation((Project)this.project, (FileObject)targetFolder);
        this.helper = new RelatedCMPHelper(this.project, configFilesFolder, this.generator);
        wiz.putProperty(PROP_HELPER, (Object)this.helper);
        this.generator.init((WizardDescriptor)wiz);
    }

    public final void uninitialize(TemplateWizard wiz) {
        this.generator.uninit();
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        if (this.helper.isCreatePU()) {
            Util.addPersistenceUnitToProjectRoot(this.project, this.helper.getLocation().getRootFolder(), Util.buildPersistenceUnitUsingData(this.project, this.getDefaultPersistenceUnitName(this.helper.getLocation().getRootFolder()), this.helper.getDatabaseConnection() != null ? this.helper.getTableSource().getName() : null, null, null));
        } else {
            Util.addPersistenceUnitToProject(this.project);
        }
        final String title = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_EntityClassesGeneration");
        ProgressContributor progressContributor = BasicAggregateProgressFactory.createProgressContributor((String)title);
        AggregateProgressHandle handle = BasicAggregateProgressFactory.createHandle((String)title, (ProgressContributor[])new ProgressContributor[]{progressContributor}, null, null);
        this.progressPanel = new ProgressPanel();
        final JComponent progressComponent = AggregateProgressFactory.createProgressComponent((AggregateProgressHandle)handle);
        final Runnable r = () -> {
            try {
                handle.start();
                this.createBeans(wiz, progressContributor);
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, null, ioe);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            finally {
                this.generator.uninit();
                handle.finish();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;

            @Override
            public void run() {
                if (!this.first) {
                    RelatedCMPWizard.this.RP.post(r);
                    RelatedCMPWizard.this.progressPanel.open(progressComponent, title);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        if (this.helper.isCreatePU() && this.helper.getDBSchemaFile() != null) {
            PUDataObject dObj = null;
            try {
                dObj = ProviderUtil.getPUDataObject(this.project, this.helper.getLocation().getRootFolder(), null);
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                // empty catch block
            }
            if (dObj != null) {
                return Collections.singleton(dObj);
            }
        }
        return Collections.singleton(DataFolder.findFolder((FileObject)SourceGroups.getFolderForPackage((SourceGroup)this.helper.getLocation(), (String)this.helper.getPackageName())));
    }

    private String getDefaultPersistenceUnitName(FileObject root) {
        FileObject owner;
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"modules/source");
        if (cp != null && (owner = cp.findOwnerRoot(root)) != null) {
            FileObject fo = root;
            FileObject prev = null;
            while (!fo.equals(owner)) {
                prev = fo;
                fo = fo.getParent();
            }
            if (prev != null && !prev.getName().isEmpty()) {
                String candidateNameBase = Character.toUpperCase(prev.getName().charAt(0)) + prev.getName().substring(1) + "PU";
                try {
                    if (!ProviderUtil.persistenceExists(this.project, root)) {
                        return candidateNameBase;
                    }
                    PUDataObject pudo = ProviderUtil.getPUDataObject(this.project, root, null);
                    Persistence persistence = pudo.getPersistence();
                    int suffix = 2;
                    PersistenceUnit[] punits = persistence.getPersistenceUnit();
                    String candidateName = candidateNameBase;
                    while (!this.isUnique(candidateName, punits)) {
                        candidateName = candidateNameBase + suffix++;
                    }
                    return candidateName;
                }
                catch (InvalidPersistenceXmlException ipex) {
                    Logger.getLogger("global").log(Level.FINE, "Invalid persistence.xml found", ipex);
                }
            }
        }
        return null;
    }

    private boolean isUnique(String candidate, PersistenceUnit[] punits) {
        for (PersistenceUnit punit : punits) {
            if (!candidate.equals(punit.getName())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBeans(TemplateWizard wiz, ProgressContributor handle) throws IOException {
        try {
            handle.start(1);
            handle.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            this.progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            FileObject dbschemaFile = this.helper.getDBSchemaFile();
            if (dbschemaFile == null) {
                FileObject configFilesFolder = RelatedCMPWizard.getHelper((WizardDescriptor)wiz).getConfigFilesFolder();
                if (configFilesFolder == null) {
                    configFilesFolder = PersistenceLocation.createLocation((Project)this.project, (FileObject)wiz.getTargetFolder().getPrimaryFile());
                }
                if (configFilesFolder == null) {
                    String message = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_NoConfigFiles");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    return;
                }
            }
            String extracting = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_ExtractingEntityClassesAndRelationships");
            handle.progress(extracting);
            this.progressPanel.setText(extracting);
            this.helper.buildBeans();
            FileObject pkg = SourceGroups.getFolderForPackage((SourceGroup)this.helper.getLocation(), (String)this.helper.getPackageName());
            this.generator.generateBeans(this.progressPanel, this.helper, dbschemaFile, handle);
        }
        finally {
            handle.finish();
            SwingUtilities.invokeLater(() -> this.progressPanel.close());
        }
    }
}

