/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.openide.util.NbBundle;

class HibernateProvider
extends Provider {
    protected HibernateProvider(String version) {
        super("org.hibernate.jpa.HibernatePersistenceProvider", version);
    }

    protected HibernateProvider() {
        this(null);
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(HibernateProvider.class, (String)"LBL_Hibernate") + (String)(this.getVersion() != null ? " (JPA " + this.getVersion() + ")" : "");
    }

    @Override
    public String getJdbcUrl() {
        return "1.0".equals(this.getVersion()) ? "hibernate.connection.url" : super.getJdbcUrl();
    }

    @Override
    public String getJdbcDriver() {
        return "1.0".equals(this.getVersion()) ? "hibernate.connection.driver_class" : super.getJdbcDriver();
    }

    @Override
    public String getJdbcUsername() {
        return "1.0".equals(this.getVersion()) ? "hibernate.connection.username" : super.getJdbcUsername();
    }

    @Override
    public String getJdbcPassword() {
        return "1.0".equals(this.getVersion()) ? "hibernate.connection.password" : super.getJdbcPassword();
    }

    @Override
    public String getTableGenerationPropertyName() {
        String result;
        String string = result = this.getVersion() != null && Float.parseFloat("2.1") <= Float.parseFloat(this.getVersion()) ? super.getTableGenerationPropertyName() : "hibernate.hbm2ddl.auto";
        if (this.isJakartaNamespace()) {
            result = result.replace("javax.persistence.", "jakarta.persistence.");
        }
        return result;
    }

    @Override
    public String getTableGenerationDropCreateValue() {
        String result;
        String string = result = this.getVersion() != null && Float.parseFloat("2.1") <= Float.parseFloat(this.getVersion()) ? super.getTableGenerationDropCreateValue() : "create-drop";
        if (this.isJakartaNamespace()) {
            result = result.replace("javax.persistence.", "jakarta.persistence.");
        }
        return result;
    }

    @Override
    public String getTableGenerationCreateValue() {
        String result;
        String string = result = this.getVersion() != null && Float.parseFloat("2.1") <= Float.parseFloat(this.getVersion()) ? super.getTableGenerationCreateValue() : "update";
        if (this.isJakartaNamespace()) {
            result = result.replace("javax.persistence.", "jakarta.persistence.");
        }
        return result;
    }

    @Override
    public Map getUnresolvedVendorSpecificProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Map getDefaultVendorSpecificProperties() {
        return Collections.singletonMap("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
    }

    @Override
    public String getAnnotationProcessor() {
        return this.getVersion() != null && !"1.0".equals(this.getVersion()) ? "org.hibernate.jpamodelgen.JPAMetaModelEntityProcessor" : super.getAnnotationProcessor();
    }
}

