/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceCfgProperties;
import org.netbeans.modules.j2ee.persistence.unit.PropertiesPanel;
import org.netbeans.modules.j2ee.persistence.unit.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyPanel
extends JPanel
implements ActionListener {
    private JTextField valueTextField = null;
    private JComboBox valueComboBox = null;
    private Provider provider;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JLabel valueLabel;
    private JPanel valuePanel;

    public PropertyPanel(PropertiesPanel.PropertiesParamHolder propParam, boolean add, String propName, String propValue) {
        this.initComponents();
        this.provider = propParam.getProvider();
        if (add) {
            this.nameComboBox.setModel(new DefaultComboBoxModel<String>(Util.getAvailPropNames(this.provider, propParam.getPU()).toArray(new String[0])));
        } else {
            this.nameComboBox.setModel(new DefaultComboBoxModel<String>(Util.getPropsNamesExceptGeneral(this.provider).toArray(new String[0])));
            this.nameComboBox.setSelectedItem(propName);
        }
        this.valueTextField = new JTextField();
        this.valueComboBox = new JComboBox();
        String selectedPropName = (String)this.nameComboBox.getSelectedItem();
        this.addValueComponent(selectedPropName, propValue);
        this.nameComboBox.addActionListener(this);
        this.nameComboBox.setEnabled(add);
    }

    public void addNameComboBoxListener(ActionListener listener) {
        this.nameComboBox.addActionListener(listener);
    }

    public void addValueComponent(String propName, String propValue) {
        this.valuePanel.removeAll();
        Object possibleValue = PersistenceCfgProperties.getPossiblePropertyValue(this.provider, propName);
        if (possibleValue == null) {
            this.valuePanel.add((Component)this.valueTextField, "Center");
            this.valueTextField.setText(propValue);
        } else if (possibleValue instanceof String[]) {
            this.valueComboBox.setModel(new DefaultComboBoxModel<String>((String[])possibleValue));
            this.valueComboBox.setEditable(true);
            this.valuePanel.add((Component)this.valueComboBox, "Center");
            if (propValue != null) {
                this.valueComboBox.setSelectedItem(propValue);
            } else {
                this.valueComboBox.setSelectedIndex(0);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public JTextField getValueTextField() {
        return this.valueTextField;
    }

    public JTextField getValueComboBoxTextField() {
        return (JTextField)this.valueComboBox.getEditor().getEditorComponent();
    }

    public String getPropertyName() {
        return (String)this.nameComboBox.getSelectedItem();
    }

    public String getPropertyValue() {
        Object possibleValue = PersistenceCfgProperties.getPossiblePropertyValue(this.provider, this.getPropertyName());
        if (possibleValue == null) {
            return this.getValueTextField().getText().trim();
        }
        return this.getValueComboBoxTextField().getText().trim();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String propName = (String)cb.getSelectedItem();
        this.addValueComponent(propName, null);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.nameComboBox = new JComboBox();
        this.valuePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PropertyPanel.class, (String)"PropertyPanel.nameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getMessage(PropertyPanel.class, (String)"PropertyPanel.valueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.nameComboBox, gridBagConstraints);
        this.valuePanel.setPreferredSize(new Dimension(27, 22));
        this.valuePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.valuePanel, gridBagConstraints);
    }
}

