/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.openide.util.Exceptions;

public class AddEntityPanel
extends JPanel {
    private final MetadataModelReadHelper<EntityMappingsMetadata, List<String>> readHelper;
    private JList entityList;
    private JScrollPane jScrollPane1;

    public static AddEntityPanel create(EntityClassScope entityClassScope, Set<String> ignoreClassNames) {
        AddEntityPanel panel = new AddEntityPanel(entityClassScope, ignoreClassNames);
        panel.initialize();
        return panel;
    }

    private AddEntityPanel(EntityClassScope entityClassScope, final Set<String> ignoreClassNames) {
        this.initComponents();
        MetadataModel model = entityClassScope.getEntityMappingsModel(true);
        this.readHelper = MetadataModelReadHelper.create(model, new MetadataModelAction<EntityMappingsMetadata, List<String>>(){

            public List<String> run(EntityMappingsMetadata metadata) {
                ArrayList<String> result = new ArrayList<String>();
                for (Entity entity : metadata.getRoot().getEntity()) {
                    String className = entity.getClass2();
                    if (ignoreClassNames.contains(className)) continue;
                    result.add(className);
                }
                Collections.sort(result);
                return result;
            }
        });
    }

    private void initialize() {
        this.readHelper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AddEntityPanel.this.readHelper.getState() == MetadataModelReadHelper.State.FINISHED) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AddEntityPanel.this.setEntityClassModel((List)AddEntityPanel.this.readHelper.getResult());
                            }
                            catch (ExecutionException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    });
                }
            }
        });
        this.readHelper.start();
    }

    private void setEntityClassModel(List<String> entityClassNames) {
        assert (SwingUtilities.isEventDispatchThread());
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String each : entityClassNames) {
            model.addElement(each);
        }
        this.entityList.setModel(model);
    }

    public List<String> getSelectedEntityClasses() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object elem : this.entityList.getSelectedValues()) {
            result.add((String)elem);
        }
        return result;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.entityList = new JList();
        this.jScrollPane1.setViewportView(this.entityList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 377, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 143, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

