/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class NoSelectedServerWarning
extends JPanel {
    public static final String OK_ENABLED = "ok_enabled";
    private final Profile j2eeProfile;
    private JButton jButtonAddServer;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JLabel listLabel;
    private JList serverList;

    private NoSelectedServerWarning(J2eeModule.Type[] moduleTypes, Profile j2eeProfile) {
        this.j2eeProfile = j2eeProfile;
        this.initComponents();
        this.serverList.setModel(new ServerListModel(moduleTypes, j2eeProfile));
        if (this.serverList.getModel().getSize() > 0) {
            this.jTextArea2.setVisible(false);
        }
        this.initServerList();
    }

    private void initServerList() {
        this.serverList.setSelectionMode(0);
        this.serverList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean enabled = !NoSelectedServerWarning.this.serverList.isSelectionEmpty();
                NoSelectedServerWarning.this.firePropertyChange(NoSelectedServerWarning.OK_ENABLED, !enabled, enabled);
            }
        });
        this.serverList.setCellRenderer(new ServersRenderer());
    }

    public static String selectServerDialog(Object[] moduleTypes, String j2eeSpec, String title, String description) {
        ArrayList<J2eeModule.Type> types = new ArrayList<J2eeModule.Type>(moduleTypes.length);
        for (Object obj : moduleTypes) {
            J2eeModule.Type type = J2eeModule.Type.fromJsrType((Object)obj);
            if (type == null) continue;
            types.add(type);
        }
        return NoSelectedServerWarning.selectServerDialog(types.toArray(new J2eeModule.Type[types.size()]), Profile.fromPropertiesString((String)j2eeSpec), title, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectServerDialog(J2eeModule.Type[] moduleTypes, Profile j2eeProfile, String title, String description) {
        NoSelectedServerWarning panel = new NoSelectedServerWarning(moduleTypes, j2eeProfile);
        Object[] options = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor desc = new DialogDescriptor((Object)panel, title, true, options, DialogDescriptor.OK_OPTION, 0, null, null);
        desc.setMessageType(2);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.getAccessibleContext().setAccessibleDescription(description);
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals(NoSelectedServerWarning.OK_ENABLED) && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        desc.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            });
            desc.setValid(panel.getSelectedInstance() != null);
            panel.setSize(panel.getPreferredSize());
            dlg.pack();
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        return desc.getValue() == DialogDescriptor.OK_OPTION ? panel.getSelectedInstance() : null;
    }

    public String getSelectedInstance() {
        if (this.serverList.getSelectedIndex() == -1) {
            return null;
        }
        return (String)this.serverList.getSelectedValue();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.serverList = new JList();
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.jButtonAddServer = new JButton();
        this.listLabel = new JLabel();
        this.setPreferredSize(new Dimension(400, 280));
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(200, 100));
        this.serverList.setSelectionMode(0);
        this.serverList.setPreferredSize(null);
        this.serverList.setVisibleRowCount(4);
        this.jScrollPane2.setViewportView(this.serverList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTextArea1.setColumns(25);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_NoSelectedServerWarning_jLabel1"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_NoSuitableServerWarning_jLabel2"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setFocusable(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddServer, (String)NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_AddServer"));
        this.jButtonAddServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoSelectedServerWarning.this.jButtonAddServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jButtonAddServer, gridBagConstraints);
        this.jButtonAddServer.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"ACSN_AddServer"));
        this.jButtonAddServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"ACSD_AddServer"));
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_NoSelectedServerWarning_listLabel", (Object[])new Object[]{this.j2eeProfile.getDisplayName()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void jButtonAddServerActionPerformed(ActionEvent evt) {
        boolean isEmpty;
        ServerListModel model = (ServerListModel)this.serverList.getModel();
        String selectedValue = (String)this.serverList.getSelectedValue();
        boolean wasEmpty = model.getSize() == 0;
        String newSelectedValue = ServerManager.showAddServerInstanceWizard();
        if (newSelectedValue != null) {
            selectedValue = newSelectedValue;
        }
        model.refreshModel();
        boolean bl = isEmpty = model.getSize() == 0;
        if (wasEmpty != isEmpty) {
            this.jTextArea2.setVisible(isEmpty);
        }
        if (selectedValue != null) {
            this.serverList.setSelectedValue(selectedValue, true);
        } else {
            this.serverList.clearSelection();
        }
    }

    private static final class ServersRenderer
    extends JLabel
    implements ListCellRenderer {
        ServersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                String id = (String)value;
                this.setText(Deployment.getDefault().getServerInstanceDisplayName(id));
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static final class ServerListModel
    extends AbstractListModel {
        private String[] instances;
        private final J2eeModule.Type[] moduleTypes;
        private final Profile j2eeProfile;

        public ServerListModel(J2eeModule.Type[] moduleTypes, Profile j2eeProfile) {
            this.moduleTypes = moduleTypes;
            this.j2eeProfile = j2eeProfile;
            this.instances = Deployment.getDefault().getServerInstanceIDs(Arrays.asList(moduleTypes), j2eeProfile);
        }

        @Override
        public synchronized int getSize() {
            return this.instances.length;
        }

        @Override
        public synchronized Object getElementAt(int index) {
            if (index >= 0 && index < this.instances.length) {
                return this.instances[index];
            }
            return null;
        }

        public synchronized void refreshModel() {
            int oldLength = this.instances.length;
            this.instances = Deployment.getDefault().getServerInstanceIDs(Arrays.asList(this.moduleTypes), this.j2eeProfile);
            if (this.instances.length > 0) {
                this.fireContentsChanged(this, 0, this.instances.length - 1);
            } else if (oldLength > 0) {
                this.fireIntervalRemoved(this, 0, oldLength - 1);
            }
        }
    }
}

