/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ServerException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AccessFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            throw new ServerException("Invalid access");
        }
        if (!this.checkAccess((HttpServletRequest)req)) {
            ((HttpServletResponse)resp).sendError(403, NbBundle.getMessage(AccessFilter.class, (String)"MSG_HTTP_FORBIDDEN"));
        }
        fc.doFilter(req, resp);
    }

    protected boolean checkAccess(HttpServletRequest request) throws IOException {
        HttpServerSettings settings = HttpServerSettings.getDefault();
        if (settings == null) {
            return false;
        }
        if (settings.getHostProperty().getHost().equals("any")) {
            return true;
        }
        Set<String> hs = settings.getGrantedAddressesSet();
        if (hs.contains(request.getRemoteAddr().trim())) {
            return true;
        }
        String pathI = request.getPathInfo();
        if (pathI == null) {
            pathI = "";
        }
        try {
            String address = request.getRemoteAddr().trim();
            if (settings.allowAccess(InetAddress.getByName(address), pathI)) {
                return true;
            }
        }
        catch (RuntimeException | UnknownHostException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return false;
    }
}

