/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.ojet.data.Bundle;
import org.netbeans.modules.html.ojet.data.DataItem;
import org.netbeans.modules.html.ojet.data.DataItemImpl;
import org.netbeans.modules.html.ojet.data.DataProvider;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class DataProviderImpl
extends DataProvider {
    private static DataProviderImpl instance = null;
    private static final String zipFolder = "docs";
    private static final String ZIP_PREFIX = "ojetdocs-";
    private static final String ZIP_EXTENSION = ".zip";
    protected static final String DEFAULT_VERSION = "2.0.0";
    private static final HashMap<String, DataItemImpl.DataItemComponent> data = new HashMap();
    private static DataItemImpl.DataItemModule moduleData = null;
    private static FileObject docRoot = null;
    private static String currentVersion;

    public static synchronized DataProvider getInstance() {
        File zipFile;
        if (instance == null) {
            instance = new DataProviderImpl();
            currentVersion = DEFAULT_VERSION;
        }
        if (data.isEmpty() && (zipFile = InstalledFileLocator.getDefault().locate("docs/" + DataProviderImpl.codeFileNameFromVersion(currentVersion), "org.netbeans.modules.html.ojet", false)) != null && zipFile.exists()) {
            FileObject folder;
            docRoot = FileUtil.toFileObject((File)zipFile);
            if ((docRoot = FileUtil.getArchiveRoot((FileObject)docRoot)) != null && (folder = docRoot.getFileObject(zipFolder)) != null && folder.isValid()) {
                for (FileObject child : folder.getChildren()) {
                    String name = child.getName();
                    if (name.startsWith("oj.oj")) {
                        name = name.substring(3);
                        data.put(name, new DataItemImpl.DataItemComponent(name, child.toURL().toString()));
                        continue;
                    }
                    if (!"ojModule".equals(name)) continue;
                    moduleData = new DataItemImpl.DataItemModule(child.toURL().toString());
                }
            }
        }
        return instance;
    }

    @Override
    public Collection<DataItem> getBindingOptions() {
        ArrayList<DataItem> result = new ArrayList<DataItem>(1);
        result.add(new DataItemImpl("ojComponent", null, "ojComponent: {component: }"));
        result.add(new DataItemImpl("ojModule", null, "ojModule: "));
        return result;
    }

    @Override
    public Collection<DataItem> getComponents() {
        ArrayList<DataItem> result = new ArrayList<DataItem>();
        for (DataItem dataItem : data.values()) {
            result.add(dataItem);
        }
        return result;
    }

    @Override
    public Collection<DataItem> getComponentOptions(String compName) {
        DataItemImpl.DataItemComponent component = data.get(compName);
        if (component != null) {
            return component.getOptions();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<DataItem> getModuleProperties() {
        if (moduleData != null) {
            return moduleData.getProperies();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<DataItem> getComponentEvents(String compName) {
        DataItemImpl.DataItemComponent component = data.get(compName);
        if (component != null) {
            return component.getEvents();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getAvailableVersions() {
        File folder = InstalledFileLocator.getDefault().locate(zipFolder, "org.netbeans.modules.html.ojet", false);
        ArrayList<String> versions = new ArrayList<String>();
        if (folder.exists()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                String fileName = file.getName();
                if (!file.isFile() || !fileName.startsWith(ZIP_PREFIX) || !fileName.endsWith(ZIP_EXTENSION)) continue;
                versions.add(DataProviderImpl.decodeVersionFromFileName(fileName));
            }
        }
        return versions;
    }

    private static String decodeVersionFromFileName(String name) {
        String version = name.substring(ZIP_PREFIX.length());
        version = version.substring(0, version.length() - ZIP_EXTENSION.length());
        version = version.replace('_', '.');
        return version;
    }

    private static String codeFileNameFromVersion(String version) {
        StringBuilder sb = new StringBuilder();
        sb.append(ZIP_PREFIX);
        sb.append(version.replace('.', '_'));
        sb.append(ZIP_EXTENSION);
        return sb.toString();
    }

    @Override
    public String getCurrentVersion() {
        return currentVersion;
    }

    @Override
    public void setCurrentVersion(String version) {
        if (!this.getAvailableVersions().contains(version)) {
            throw new IllegalArgumentException(version + " is unknown version");
        }
        if (!currentVersion.equals(version)) {
            currentVersion = version;
            data.clear();
        }
    }

    @Override
    public Collection<JsObject> getGlobalObjects(ModelElementFactory factory) {
        JsFunction global = factory.newGlobalObject(null, 0);
        JsObject oj = factory.newObject((JsObject)global, "oj", OffsetRange.NONE, true, Bundle.label_ojet());
        factory.putGlobalProperty(global, oj);
        return Collections.singletonList(global);
    }
}

