/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodRunnerProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodDebuggerProvider {
    private final String command = "debug.single.method";
    private RequestProcessor.Task singleMethodTask;
    private SingleMethod singleMethod;

    public abstract boolean canHandle(Node var1);

    public abstract SingleMethod getTestMethod(Document var1, int var2);

    public boolean isTestClass(Node activatedNode) {
        return true;
    }

    public final void debugTestMethod(Node activatedNode) {
        int caret;
        Document doc;
        Node activeNode = activatedNode;
        final EditorCookie ec = (EditorCookie)activeNode.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane pane = (JEditorPane)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JEditorPane>(){

                public JEditorPane run() {
                    return NbDocument.findRecentEditorPane((EditorCookie)ec);
                }
            });
            if (pane != null) {
                doc = pane.getDocument();
                caret = pane.getCaret().getDot();
            } else {
                doc = null;
                caret = -1;
            }
        } else {
            doc = null;
            caret = -1;
        }
        this.singleMethod = (SingleMethod)activeNode.getLookup().lookup(SingleMethod.class);
        if (this.singleMethod == null) {
            RequestProcessor RP = new RequestProcessor("TestMethodDebuggerProvider", 1, true);
            this.singleMethodTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    TestMethodDebuggerProvider.this.singleMethod = TestMethodRunnerProvider.findTestMethod(doc, caret, TestMethodDebuggerProvider.this::getTestMethod);
                }
            });
            final ProgressHandle ph = ProgressHandleFactory.createHandle((String)Bundle.Search_For_Test_Method(), (Cancellable)this.singleMethodTask);
            this.singleMethodTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    ph.finish();
                    if (TestMethodDebuggerProvider.this.singleMethod == null) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.No_Test_Method_Found());
                    } else {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                ActionProvider ap = CommonUtils.getInstance().getActionProvider(TestMethodDebuggerProvider.this.singleMethod.getFile());
                                if (ap != null && Arrays.asList(ap.getSupportedActions()).contains("debug.single.method") && ap.isActionEnabled("debug.single.method", Lookups.singleton((Object)TestMethodDebuggerProvider.this.singleMethod))) {
                                    ap.invokeAction("debug.single.method", Lookups.singleton((Object)TestMethodDebuggerProvider.this.singleMethod));
                                }
                            }
                        });
                    }
                }
            });
            ph.start();
            this.singleMethodTask.schedule(0);
        }
    }
}

